/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.encrypt;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import de.adorsys.multibanking.encrypt.Encrypted;
import de.adorsys.multibanking.encrypt.EncryptionUtil;
import de.adorsys.multibanking.encrypt.UserSecret;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.stereotype.Component;

@Component
public class EncryptionEventListener
extends AbstractMongoEventListener<Object> {
    private static final String ENCRYPTION_METHOD = "AES";
    private static final String ID_FIELD = "_id";
    private static final String ENCRYPTION_FIELD = "encrypted";
    @Value(value="${db_secret}")
    private String databaseSecret;
    @Autowired
    private UserSecret userSecret;

    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        Object source = event.getSource();
        if (!source.getClass().isAnnotationPresent(Encrypted.class)) {
            return;
        }
        DBObject dbObject = event.getDBObject();
        String json = JSON.serialize((Object)dbObject);
        String encrypted = EncryptionUtil.encrypt(json, this.secretKey());
        List<List<String>> excludes = this.loadExcludes(source.getClass().getAnnotation(Encrypted.class).exclude());
        this.mergeFields(excludes, dbObject);
        dbObject.put(ENCRYPTION_FIELD, (Object)encrypted);
    }

    public void onAfterLoad(AfterLoadEvent event) {
        Class source = event.getType();
        if (!source.isAnnotationPresent(Encrypted.class) || event.getDBObject().get(ENCRYPTION_FIELD) == null) {
            return;
        }
        DBObject dbObject = event.getDBObject();
        String decryptedJson = EncryptionUtil.decrypt(dbObject.get(ENCRYPTION_FIELD).toString(), this.secretKey());
        List<List<String>> excludes = this.loadExcludes(source.getAnnotation(Encrypted.class).exclude());
        DBObject decryptedDbObject = (DBObject)JSON.parse((String)decryptedJson);
        this.mergeFields(excludes, dbObject, decryptedDbObject);
    }

    private List<List<String>> loadExcludes(String[] excludes) {
        return Stream.of(excludes).map(exclude -> Arrays.asList(StringUtils.splitByWholeSeparator((String)exclude, (String)"."))).collect(Collectors.toList());
    }

    private void removeAllFields(DBObject dbObject) {
        String[] fields;
        for (String field : fields = dbObject.keySet().toArray(new String[0])) {
            dbObject.removeField(field);
        }
    }

    private void mergeFields(List<List<String>> excludes, DBObject dbObject) {
        BasicDBObject copy = new BasicDBObject();
        excludes.forEach(exclude -> this.copyField((List<String>)exclude, dbObject, copy));
        this.removeAllFields(dbObject);
        dbObject.putAll(copy.toMap());
    }

    private void mergeFields(List<List<String>> excludes, DBObject dbObject, DBObject decryptedDbObject) {
        DBObject copy = this.createDbObject(dbObject, decryptedDbObject);
        this.removeAllFields(dbObject);
        this.convertMapToDBObject(copy);
        dbObject.putAll(copy.toMap());
    }

    private DBObject createDbObject(DBObject dbObject, DBObject decryptedDbObject) {
        BasicDBObject copy;
        BasicDBObject basicDBObject = copy = decryptedDbObject == null ? new BasicDBObject() : new BasicDBObject(decryptedDbObject.toMap());
        if (copy.get(ID_FIELD) == null) {
            copy.put((Object)ID_FIELD, dbObject.get(ID_FIELD));
        }
        return copy;
    }

    private void convertMapToDBObject(DBObject dbObject) {
        String[] fields;
        for (String field : fields = dbObject.keySet().toArray(new String[0])) {
            Object obj = dbObject.get(field);
            if (!(obj instanceof Map)) continue;
            BasicDBObject basicDBObject = new BasicDBObject((Map)obj);
            dbObject.put(field, (Object)basicDBObject);
            this.convertMapToDBObject((DBObject)basicDBObject);
        }
    }

    private void copyField(List<String> excludes, DBObject dbObject, BasicDBObject basicDBObject) {
        if (excludes.isEmpty()) {
            return;
        }
        String field = excludes.get(0);
        Object obj = dbObject.get(field);
        basicDBObject.put((Object)field, obj);
        if (obj instanceof DBObject) {
            this.copyField(excludes.subList(1, excludes.size()), (DBObject)obj, (BasicDBObject)basicDBObject.get(field));
        }
    }

    private SecretKey secretKey() {
        return new SecretKeySpec(this.getUserSecret().getBytes(), ENCRYPTION_METHOD);
    }

    private String getUserSecret() {
        try {
            if (this.userSecret.getSecret() == null) {
                return this.databaseSecret;
            }
            return this.userSecret.getSecret();
        }
        catch (BeanCreationException e) {
            return this.databaseSecret;
        }
    }
}

