/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.conf;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import de.adorsys.multibanking.conf.ContinueOnBatchErrorTemplate;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

@Configuration
@PropertySource(value={"${mongo.properties.url}"}, ignoreResourceNotFound=true)
@Profile(value={"mongo"})
public class MongoConfig
extends AbstractMongoConfiguration {
    @Autowired
    Environment env;

    protected String getDatabaseName() {
        return this.env.getProperty("mongo.databaseName");
    }

    public Mongo mongo() throws Exception {
        return this.mongoClient();
    }

    @Bean
    @Autowired
    public MongoTemplate mongoTemplate() throws UnknownHostException {
        return new ContinueOnBatchErrorTemplate(this.mongoDbFactory());
    }

    @Bean
    public MongoClient mongoClient() throws UnknownHostException {
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        builder.connectionsPerHost(50);
        builder.writeConcern(WriteConcern.JOURNALED);
        builder.readPreference(ReadPreference.secondaryPreferred());
        MongoClientOptions options = builder.build();
        ServerAddress serverAddress = this.getServerAddress();
        if (StringUtils.isEmpty((CharSequence)this.env.getProperty("mongo.userName"))) {
            return new MongoClient(serverAddress, options);
        }
        MongoCredential mongoCredential = MongoCredential.createCredential((String)this.env.getProperty("mongo.userName"), (String)this.env.getProperty("mongo.databaseName"), (char[])this.env.getProperty("mongo.password").toCharArray());
        return new MongoClient(serverAddress, Collections.singletonList(mongoCredential), options);
    }

    private ServerAddress getServerAddress() {
        String[] serverParts = this.env.getProperty("mongo.server").replace("mongodb://", "").split(":");
        return new ServerAddress(serverParts[0], 1 < serverParts.length ? Integer.valueOf(serverParts[1]) : ServerAddress.defaultPort());
    }

    public MongoDbFactory mongoDbFactory() throws UnknownHostException {
        return new SimpleMongoDbFactory(this.mongoClient(), this.env.getProperty("mongo.databaseName"));
    }
}

