/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.encrypt;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.PasswordLookup;
import de.adorsys.multibanking.domain.KeyStoreEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.keystore.KeystoreData;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.envutils.EnvProperties;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreUtils {
    public static JWKSet loadPrivateKeys(KeyStoreEntity keyStoreEntity) {
        KeyStore keyStore;
        String serverKeystoreName = EnvProperties.getEnvOrSysProp((String)"SERVER_KEYSTORE_NAME", (String)"multibanking-service-keystore");
        String serverKeystorePassword = EnvProperties.getEnvOrSysProp((String)"KEYSTORE_PASSWORD", (boolean)true);
        if (StringUtils.isBlank((CharSequence)serverKeystorePassword)) {
            throw new IllegalStateException("Missing environment property KEYSTORE_PASSWORD");
        }
        char[] keyPairPassword = serverKeystorePassword.toCharArray();
        PasswordCallbackHandler storePassHandler = new PasswordCallbackHandler(keyPairPassword);
        try {
            byte[] keyStoreBytes = keyStoreEntity.getEncData();
            KeystoreData keystoreData = KeystoreData.parseFrom((byte[])keyStoreBytes);
            keyStore = KeyStoreUtils.initKeystore(keystoreData, serverKeystoreName, (CallbackHandler)storePassHandler);
        }
        catch (IOException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | WrongKeystoreCredentialException e) {
            throw new IllegalStateException(e);
        }
        return KeyStoreUtils.exportPrivateKeys(keyStore, keyPairPassword);
    }

    private static JWKSet exportPrivateKeys(KeyStore keyStore, char[] keypass) {
        PasswordLookup pwLookup = name -> keypass;
        try {
            return JWKSet.load((KeyStore)keyStore, (PasswordLookup)pwLookup);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private static KeyStore initKeystore(KeystoreData keystoreData, String storeid, CallbackHandler handler) throws WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, CertificateException, IOException {
        try {
            return KeyStoreUtils.loadKeyStore(new ByteArrayInputStream(keystoreData.getKeystore().toByteArray()), storeid, keystoreData.getType(), handler);
        }
        catch (UnrecoverableKeyException e) {
            throw new WrongKeystoreCredentialException((Throwable)e);
        }
        catch (KeyStoreException e) {
            if (e.getCause() != null) {
                Throwable cause = e.getCause();
                if (cause instanceof NoSuchAlgorithmException) {
                    throw new MissingKeystoreAlgorithmException(cause.getMessage(), cause);
                }
                if (cause instanceof NoSuchProviderException) {
                    throw new MissingKeystoreProviderException(cause.getMessage(), cause);
                }
            }
            throw new IllegalStateException("Unidentified keystore exception", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MissingKeyAlgorithmException(e.getMessage(), (Throwable)e);
        }
    }

    private static KeyStore loadKeyStore(InputStream in, String storeId, String storeType, CallbackHandler storePassSrc) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        if (StringUtils.isBlank((CharSequence)storeType)) {
            storeType = "UBER";
        }
        KeyStore ks = KeyStore.getInstance(storeType, (Provider)new BouncyCastleProvider());
        try {
            ks.load(in, PasswordCallbackUtils.getPassword((CallbackHandler)storePassSrc, (String)storeId));
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof BadPaddingException) {
                throw new UnrecoverableKeyException(e.getMessage());
            }
            throw e;
        }
        return ks;
    }
}

