/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.conf;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.InsertOptions;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoTemplate;

public class ContinueOnBatchErrorTemplate
extends MongoTemplate {
    private static List<String> continueOnErrorCollections = Arrays.asList("bookingEntity", "anonymizedBookingEntity");
    private static final String ID_FIELD = "_id";

    public ContinueOnBatchErrorTemplate(MongoDbFactory mongoDbFactory) {
        super(mongoDbFactory);
    }

    protected List<ObjectId> insertDBObjectList(final String collectionName, final List<DBObject> dbDocList) {
        if (dbDocList.isEmpty()) {
            return Collections.emptyList();
        }
        this.execute(collectionName, (CollectionCallback)new CollectionCallback<Void>(){

            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                MongoAction mongoAction = new MongoAction(null, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
                WriteConcern writeConcernToUse = ContinueOnBatchErrorTemplate.this.prepareWriteConcern(mongoAction);
                InsertOptions insertOptions = new InsertOptions().writeConcern(writeConcernToUse).continueOnError(continueOnErrorCollections.contains(collectionName));
                WriteResult writeResult = collection.insert(dbDocList, insertOptions);
                ContinueOnBatchErrorTemplate.this.handleAnyWriteResultErrors(writeResult, null, MongoActionOperation.INSERT_LIST);
                return null;
            }
        });
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (DBObject dbo : dbDocList) {
            Object id = dbo.get(ID_FIELD);
            if (id instanceof ObjectId) {
                ids.add((ObjectId)id);
                continue;
            }
            ids.add(null);
        }
        return ids;
    }
}

