/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import com.google.common.collect.Sets;
import de.adorsys.multibanking.domain.CustomRuleEntity;
import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.pers.spi.repository.BookingRuleRepositoryIf;
import de.adorsys.multibanking.repository.CustomRuleRepositoryMongodb;
import de.adorsys.multibanking.repository.RuleRepositoryMongodb;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRuleRepositoryImpl
implements BookingRuleRepositoryIf {
    @Autowired
    private RuleRepositoryMongodb ruleRepository;
    @Autowired
    private CustomRuleRepositoryMongodb customRuleRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<RuleEntity> findByIncoming(boolean incoming) {
        return this.ruleRepository.findByIncoming(incoming);
    }

    public List<CustomRuleEntity> findByUserIdAndIncomingCustomRules(String userId, boolean incoming) {
        return this.customRuleRepository.findByIncoming(incoming);
    }

    public Page<? extends RuleEntity> findAllPageable(Pageable pageable, boolean custom) {
        if (custom) {
            return this.customRuleRepository.findAll(pageable);
        }
        return this.ruleRepository.findAll(pageable);
    }

    public List<? extends RuleEntity> findAll(boolean custom) {
        if (custom) {
            return this.customRuleRepository.findAll();
        }
        return this.ruleRepository.findAll();
    }

    public CustomRuleEntity createOrUpdateCustomRule(CustomRuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        return (CustomRuleEntity)this.customRuleRepository.save(ruleEntity);
    }

    public RuleEntity createOrUpdateRule(RuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        return (RuleEntity)this.ruleRepository.save(ruleEntity);
    }

    public List<? extends RuleEntity> search(boolean customRules, String text) {
        HashSet terms = Sets.newHashSet(Arrays.asList(text.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        if (customRules) {
            return this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), CustomRuleEntity.class);
        }
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), RuleEntity.class);
    }

    public Optional<? extends RuleEntity> getRuleById(boolean customRule, String ruleId) {
        if (customRule) {
            return this.customRuleRepository.getRuleById(ruleId);
        }
        return this.ruleRepository.getRuleById(ruleId);
    }

    public void deleteCustomRule(String id) {
        this.customRuleRepository.delete((Serializable)((Object)id));
    }

    public void deleteRule(String id) {
        this.ruleRepository.delete((Serializable)((Object)id));
    }

    public void replacesRules(List<? extends RuleEntity> rules, boolean custom) {
        if (custom) {
            this.mongoTemplate.remove(new Query(), CustomRuleEntity.class);
            this.customRuleRepository.save(rules);
        } else {
            this.mongoTemplate.remove(new Query(), RuleEntity.class);
            this.ruleRepository.save(rules);
        }
    }
}

