/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.repository;

import de.adorsys.multibanking.domain.BankAccountEntity;
import domain.BankAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
@Profile(value={"mongo", "fongo"})
public class BankAccountRepositoryCustomMongodb {
    @Autowired
    private MongoTemplate mongoTemplate;

    public BankAccount.SyncStatus getSyncStatus(String accountId) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)accountId));
        where.fields().include("syncStatus");
        return ((BankAccountEntity)this.mongoTemplate.findOne(where, BankAccountEntity.class)).getSyncStatus();
    }

    public void updateSyncStatus(String accountId, BankAccount.SyncStatus syncStatus) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)accountId));
        Update update = new Update().set("syncStatus", (Object)syncStatus);
        this.mongoTemplate.updateFirst(where, update, BankAccountEntity.class);
    }
}

