/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.repository.BankAccountRepositoryCustomMongodb;
import de.adorsys.multibanking.repository.BankAccountRepositoryMongodb;
import domain.BankAccount;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankAccountRepositoryImpl
implements BankAccountRepositoryIf {
    @Autowired
    private BankAccountRepositoryMongodb bankAccountRepository;
    @Autowired
    private BankAccountRepositoryCustomMongodb bankAccountRepositoryCustom;

    public List<BankAccountEntity> findByUserIdAndBankAccessId(String userId, String bankAccessId) {
        return this.bankAccountRepository.findByUserIdAndBankAccessId(userId, bankAccessId);
    }

    public Optional<BankAccountEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccountRepository.findByUserIdAndId(userId, id);
    }

    public boolean exists(String accountId) {
        return this.bankAccountRepository.exists((Serializable)((Object)accountId));
    }

    public void save(List<BankAccountEntity> bankAccounts) {
        this.bankAccountRepository.save(bankAccounts);
    }

    public void save(BankAccountEntity bankAccount) {
        this.bankAccountRepository.save(bankAccount);
    }

    public BankAccount.SyncStatus getSyncStatus(String accountId) {
        return this.bankAccountRepositoryCustom.getSyncStatus(accountId);
    }

    public void updateSyncStatus(String accountId, BankAccount.SyncStatus syncStatus) {
        this.bankAccountRepositoryCustom.updateSyncStatus(accountId, syncStatus);
    }

    public List<BankAccountEntity> deleteByBankAccess(String accessId) {
        return this.bankAccountRepository.deleteByBankAccessId(accessId);
    }
}

