/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.encrypt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import de.adorsys.multibanking.encrypt.Encrypted;
import de.adorsys.multibanking.encrypt.EncryptionUtil;
import de.adorsys.multibanking.encrypt.UserSecret;
import java.util.Arrays;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.stereotype.Component;

@Component
public class EncryptionEventListener
extends AbstractMongoEventListener<Object> {
    @Value(value="${db_secret}")
    String databaseSecret;
    @Autowired
    UserSecret userSecret;
    private ObjectMapper objectMapper = new ObjectMapper();

    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        Object source = event.getSource();
        if (source.getClass().isAnnotationPresent(Encrypted.class)) {
            try {
                String secret = this.getUserSecret();
                SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), "AES");
                String json = this.objectMapper.writeValueAsString((Object)event.getDBObject());
                String encrypted = EncryptionUtil.encrypt(json, secretKey);
                List<String> excludeFields = Arrays.asList(source.getClass().getAnnotation(Encrypted.class).exclude());
                Object[] keySet = event.getDBObject().keySet().toArray();
                for (int i = keySet.length - 1; i >= 0; --i) {
                    if (excludeFields.contains(keySet[i].toString())) continue;
                    event.getDBObject().removeField(keySet[i].toString());
                }
                event.getDBObject().put("encrypted", (Object)encrypted);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onAfterLoad(AfterLoadEvent event) {
        Class source = event.getType();
        if (source.isAnnotationPresent(Encrypted.class)) {
            int i;
            if (event.getDBObject().get("encrypted") == null) {
                return;
            }
            String secret = this.getUserSecret();
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), "AES");
            String decryptedJson = EncryptionUtil.decrypt(event.getDBObject().get("encrypted").toString(), secretKey);
            DBObject decryptedDbObject = (DBObject)JSON.parse((String)decryptedJson);
            List<String> exclude = Arrays.asList(source.getAnnotation(Encrypted.class).exclude());
            Object[] keySet = event.getDBObject().keySet().toArray();
            for (i = keySet.length - 1; i >= 0; --i) {
                if (exclude.contains(keySet[i].toString())) continue;
                event.getDBObject().removeField(keySet[i].toString());
            }
            keySet = decryptedDbObject.keySet().toArray();
            for (i = keySet.length - 1; i >= 0; --i) {
                String key = keySet[i].toString();
                if (exclude.contains(key)) continue;
                event.getDBObject().put(key, decryptedDbObject.get(key));
            }
        }
    }

    private String getUserSecret() {
        if (this.userSecret.getSecret() == null) {
            return this.databaseSecret;
        }
        return this.userSecret.getSecret();
    }
}

