/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.repository.BankAccessRepositoryMongodb;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankAccessRepositoryImpl
implements BankAccessRepositoryIf {
    @Autowired
    private BankAccessRepositoryMongodb bankAccessRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public Optional<BankAccessEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccessRepository.findByUserIdAndId(userId, id);
    }

    public BankAccessEntity findOne(String id) {
        return (BankAccessEntity)this.bankAccessRepository.findOne((Serializable)((Object)id));
    }

    public List<BankAccessEntity> findByUserId(String userId) {
        return this.bankAccessRepository.findByUserId(userId);
    }

    public BankAccessEntity save(BankAccessEntity bankAccess) {
        return (BankAccessEntity)this.bankAccessRepository.save(bankAccess);
    }

    public String getBankCode(String id) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        BankAccessEntity found = (BankAccessEntity)this.mongoTemplate.findOne(where, BankAccessEntity.class);
        return found != null ? found.getBankCode() : null;
    }

    public boolean exists(String accessId) {
        return this.bankAccessRepository.exists((Serializable)((Object)accessId));
    }

    public boolean deleteByUserIdAndBankAccessId(String userId, String bankAccessId) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)bankAccessId).and("userId").is((Object)userId));
        return this.mongoTemplate.remove(where, BankAccessEntity.class).getN() > 0;
    }
}

