/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.repository.BookingRepositoryMongodb;
import domain.BankApi;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRepositoryImpl
implements BookingRepositoryIf {
    @Autowired
    BookingRepositoryMongodb bookingRepository;

    public List<BookingEntity> findByUserIdAndAccountIdAndBankApi(String userId, String bankAccountId, BankApi bankApi) {
        return this.bookingRepository.findByUserIdAndAccountIdAndBankApi(userId, bankAccountId, bankApi, new Sort(Sort.Direction.DESC, new String[]{"valutaDate"}));
    }

    public Optional<BookingEntity> findByUserIdAndId(String userId, String bookingId) {
        return this.bookingRepository.findByUserIdAndId(userId, bookingId);
    }

    public void insert(List<BookingEntity> bookingEntities) {
        this.bookingRepository.insert(bookingEntities);
    }

    public List<BookingEntity> save(List<BookingEntity> bookingEntities) {
        return this.bookingRepository.save(bookingEntities);
    }

    public void deleteByAccountId(String id) {
        this.bookingRepository.deleteByAccountId(id);
    }
}

