/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import de.adorsys.multibanking.repository.BankRepositoryMongodb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankRepositoryImpl
implements BankRepositoryIf {
    @Autowired
    BankRepositoryMongodb bankRepositoryMongodb;
    @Autowired
    MongoTemplate mongoTemplate;

    public Optional<BankEntity> findByBankCode(String blz) {
        return this.bankRepositoryMongodb.findByBankCode(blz);
    }

    public void save(BankEntity bank) {
        this.bankRepositoryMongodb.save(bank);
    }

    public List<BankEntity> search(String text) {
        HashSet terms = Sets.newHashSet(Arrays.asList(text.split(" ")));
        ArrayList searchIdx = Lists.newArrayList();
        for (Object term : terms) {
            searchIdx.add(((String)term).toLowerCase());
        }
        Criteria searchIndex = new Criteria();
        for (String term : terms) {
            searchIndex.and("searchIndex").regex(Pattern.compile("^" + Pattern.quote(term)));
        }
        List bankEntities = this.mongoTemplate.find(Query.query((CriteriaDefinition)searchIndex), BankEntity.class);
        return bankEntities;
    }
}

