/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.conf;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.InsertOptions;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

@Configuration
@Profile(value={"mongo"})
@PropertySource(value={"classpath:/mongo.properties"})
public class MongoConfig
extends AbstractMongoConfiguration {
    @Autowired
    Environment env;

    protected String getDatabaseName() {
        return this.env.getProperty("mongo.databaseName");
    }

    public Mongo mongo() throws Exception {
        return this.mongoClient();
    }

    @Bean
    @Autowired
    public MongoTemplate mongoTemplate() throws UnknownHostException {
        return new ContinueOnBatchErrorTemplate(this.mongoDbFactory());
    }

    @Bean
    public MongoClient mongoClient() throws UnknownHostException {
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        builder.connectionsPerHost(50);
        builder.writeConcern(WriteConcern.JOURNALED);
        builder.readPreference(ReadPreference.secondaryPreferred());
        MongoClientOptions options = builder.build();
        MongoCredential mongoCredential = MongoCredential.createMongoCRCredential((String)this.env.getProperty("mongo.userName"), (String)this.env.getProperty("mongo.databaseName"), (char[])this.env.getProperty("mongo.password").toCharArray());
        if (mongoCredential.getUserName().isEmpty()) {
            return new MongoClient(new ServerAddress(this.env.getProperty("mongo.server"), Integer.parseInt(this.env.getProperty("mongo.port"))), options);
        }
        return new MongoClient(new ServerAddress(this.env.getProperty("mongo.server"), Integer.parseInt(this.env.getProperty("mongo.port"))), Collections.singletonList(mongoCredential), options);
    }

    public MongoDbFactory mongoDbFactory() throws UnknownHostException {
        return new SimpleMongoDbFactory(this.mongoClient(), this.env.getProperty("mongo.databaseName"));
    }

    private class ContinueOnBatchErrorTemplate
    extends MongoTemplate {
        private static final String ID_FIELD = "_id";

        public ContinueOnBatchErrorTemplate(MongoDbFactory mongoDbFactory) {
            super(mongoDbFactory);
        }

        protected List<ObjectId> insertDBObjectList(final String collectionName, final List<DBObject> dbDocList) {
            if (dbDocList.isEmpty()) {
                return Collections.emptyList();
            }
            this.execute(collectionName, (CollectionCallback)new CollectionCallback<Void>(){

                public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                    MongoAction mongoAction = new MongoAction(null, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
                    WriteConcern writeConcernToUse = ContinueOnBatchErrorTemplate.this.prepareWriteConcern(mongoAction);
                    InsertOptions insertOptions = new InsertOptions().writeConcern(writeConcernToUse).continueOnError(collectionName.equals("booking"));
                    WriteResult writeResult = collection.insert(dbDocList, insertOptions);
                    ContinueOnBatchErrorTemplate.this.handleAnyWriteResultErrors(writeResult, null, MongoActionOperation.INSERT_LIST);
                    return null;
                }
            });
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            for (DBObject dbo : dbDocList) {
                Object id = dbo.get(ID_FIELD);
                if (id instanceof ObjectId) {
                    ids.add((ObjectId)id);
                    continue;
                }
                ids.add(null);
            }
            return ids;
        }
    }
}

