/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.BookingsIndexEntity;
import de.adorsys.multibanking.mongo.entity.BookingsIndexMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BookingsIndexRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BookingsIndexRepositoryIf;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingsIndexRepositoryImpl
implements BookingsIndexRepositoryIf {
    private final BookingsIndexRepositoryMongodb repositoryMongodb;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public void save(BookingsIndexEntity entity) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)entity.getUserId()).and("accountId").is((Object)entity.getAccountId()));
        this.mongoTemplate.remove(query, BookingsIndexMongoEntity.class);
        this.repositoryMongodb.save(this.entityMapper.mapToBookingsIndexMongoEntity(entity));
    }

    public void delete(BookingsIndexEntity entity) {
        this.repositoryMongodb.deleteById(entity.getId());
    }

    public List<BookingsIndexEntity> search(String text) {
        HashSet<String> terms = new HashSet<String>(Arrays.asList(text.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        return this.entityMapper.mapToBookingsIndexEntities(this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), BookingsIndexMongoEntity.class));
    }

    public Optional<BookingsIndexEntity> findByUserIdAndAccountId(String userId, String accountId) {
        return this.repositoryMongodb.findByUserIdAndAccountId(userId, accountId).map(this.entityMapper::mapToBookingsIndexEntity);
    }

    public BookingsIndexRepositoryImpl(BookingsIndexRepositoryMongodb repositoryMongodb, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.repositoryMongodb = repositoryMongodb;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

