/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.mongo.entity.BankAccessMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BankAccessRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankAccessRepositoryImpl
implements BankAccessRepositoryIf {
    private final BankAccessRepositoryMongodb bankAccessRepository;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public Optional<BankAccessEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccessRepository.findByUserIdAndId(userId, id).map(this.entityMapper::mapToBankAccessEntity);
    }

    public List<BankAccessEntity> findByUserId(String userId) {
        return this.entityMapper.mapToBankAccessEntities(this.bankAccessRepository.findByUserId(userId));
    }

    public void save(BankAccessEntity bankAccess) {
        BankAccessMongoEntity bankAccessMongoEntity = (BankAccessMongoEntity)((Object)this.bankAccessRepository.save((Object)this.entityMapper.mapToBankAccessMongoEntity(bankAccess)));
        bankAccess.setId(bankAccessMongoEntity.getId());
    }

    public String getBankCode(String id) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        query.fields().include("bankCode");
        return Optional.ofNullable((BankAccessMongoEntity)((Object)this.mongoTemplate.findOne(query, BankAccessMongoEntity.class))).map(BankAccess::getBankCode).orElse(null);
    }

    public boolean exists(String accessId) {
        return this.bankAccessRepository.existsById(accessId);
    }

    public boolean deleteByUserIdAndBankAccessId(String userId, String id) {
        return this.bankAccessRepository.deleteByUserIdAndId(userId, id) > 0L;
    }

    public BankAccessRepositoryImpl(BankAccessRepositoryMongodb bankAccessRepository, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.bankAccessRepository = bankAccessRepository;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

