/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.mongo.entity.AccountAnalyticsMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.AnalyticsRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class AnalyticsRepositoryImpl
implements AnalyticsRepositoryIf {
    private final AnalyticsRepositoryMongodb analyticsRepository;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public Optional<AccountAnalyticsEntity> findLastByUserIdAndAccountId(String userId, String bankAccountId) {
        return this.analyticsRepository.findLastByUserIdAndAccountId(userId, bankAccountId).map(this.entityMapper::mapToAccountAnalyticsEntity);
    }

    public Optional<LocalDateTime> findLastAnalyticsDateByUserIdAndAccountId(String userId, String bankAccountId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId).and("accountId").is((Object)bankAccountId));
        query.fields().include("analyticsDate");
        return Optional.ofNullable((AccountAnalyticsMongoEntity)this.mongoTemplate.findOne(query, AccountAnalyticsMongoEntity.class)).map(AccountAnalyticsMongoEntity::getAnalyticsDate);
    }

    public void save(AccountAnalyticsEntity accountAnalyticsEntity) {
        this.analyticsRepository.save(this.entityMapper.mapToAccountAnalyticsMongoEntity(accountAnalyticsEntity));
    }

    public void deleteByAccountId(String id) {
        this.analyticsRepository.deleteByAccountId(id);
    }

    public AnalyticsRepositoryImpl(AnalyticsRepositoryMongodb analyticsRepository, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.analyticsRepository = analyticsRepository;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

