/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.RawSepaTransactionEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.RawSepaTransactionRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.RawSepaTransactionRepositoryIf;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class RawSepaTransactionRepositoryImpl
implements RawSepaTransactionRepositoryIf {
    private final RawSepaTransactionRepositoryMongodb paymentRepository;
    private final MongoEntityMapper entityMapper;

    public Optional<RawSepaTransactionEntity> findByUserIdAndId(String userId, String id) {
        return this.paymentRepository.findByUserIdAndId(userId, id).map(this.entityMapper::mapToRawSepaTransactionEntity);
    }

    public void save(RawSepaTransactionEntity paymentEntity) {
        this.paymentRepository.save((Object)this.entityMapper.mapToRawSepaTransactionMongoEntity(paymentEntity));
    }

    public void delete(String id) {
        this.paymentRepository.deleteById(id);
    }

    public RawSepaTransactionRepositoryImpl(RawSepaTransactionRepositoryMongodb paymentRepository, MongoEntityMapper entityMapper) {
        this.paymentRepository = paymentRepository;
        this.entityMapper = entityMapper;
    }
}

