/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.mongo.entity.RuleMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BookingRuleRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BookingRuleRepositoryIf;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRuleRepositoryImpl
implements BookingRuleRepositoryIf {
    private final BookingRuleRepositoryMongodb ruleRepository;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public List<RuleEntity> findByUserId(String userId) {
        return this.entityMapper.mapToRuleEntities(this.ruleRepository.findByUserId(userId));
    }

    public Page<RuleEntity> findAllPageable(Pageable pageable) {
        Page<RuleMongoEntity> pageRules = this.ruleRepository.findAll(pageable);
        return pageRules.map(this.entityMapper::mapToRuleEntity);
    }

    public List<RuleEntity> findAll() {
        return this.entityMapper.mapToRuleEntities(this.ruleRepository.findAll());
    }

    public void createOrUpdateRule(RuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        this.ruleRepository.save((Object)this.entityMapper.mapToRuleMongoEntity(ruleEntity));
    }

    public List<RuleEntity> search(String text) {
        HashSet<String> terms = new HashSet<String>(Arrays.asList(text.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        return this.entityMapper.mapToRuleEntities(this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), RuleMongoEntity.class));
    }

    public Optional<RuleEntity> findById(String id) {
        return this.ruleRepository.findById(id).map(this.entityMapper::mapToRuleEntity);
    }

    public Optional<RuleEntity> findByRuleId(String ruleId) {
        return this.ruleRepository.findByRuleId(ruleId).map(this.entityMapper::mapToRuleEntity);
    }

    public void deleteRule(String id) {
        this.ruleRepository.deleteById(id);
    }

    public BookingRuleRepositoryImpl(BookingRuleRepositoryMongodb ruleRepository, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.ruleRepository = ruleRepository;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

