/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.mongo.entity.UserMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.UserRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class UserRepositoryImpl
implements UserRepositoryIf {
    private final UserRepositoryMongodb userRepository;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public Optional<UserEntity> findById(String id) {
        return this.userRepository.findById(id).map(this.entityMapper::mapToUserEntity);
    }

    public List<String> findExpiredUser() {
        return this.userRepository.findByExpireUserLessThan(LocalDateTime.now()).stream().map(UserMongoEntity::getId).collect(Collectors.toList());
    }

    public Optional<LocalDateTime> getRulesLastChangeDate(String id) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        query.fields().include("rulesLastChangeDate");
        return Optional.ofNullable(this.mongoTemplate.findOne(query, UserMongoEntity.class)).map(UserMongoEntity::getRulesLastChangeDate);
    }

    public void setRulesLastChangeDate(String userId, LocalDateTime dateTime) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)userId));
        Update update = new Update().set("rulesLastChangeDate", (Object)dateTime);
        this.mongoTemplate.updateFirst(where, update, UserMongoEntity.class);
    }

    public boolean exists(String userId) {
        return this.userRepository.existsById(userId);
    }

    public void save(UserEntity userEntity) {
        this.userRepository.save(this.entityMapper.mapToUserMongoEntity(userEntity));
    }

    public void delete(String userId) {
        this.userRepository.deleteById(userId);
    }

    public UserRepositoryImpl(UserRepositoryMongodb userRepository, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.userRepository = userRepository;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

