/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.ConsentRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.ConsentRepositoryIf;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class ConsentRepositoryImpl
implements ConsentRepositoryIf {
    private final ConsentRepositoryMongodb consentRepository;
    private final MongoEntityMapper entityMapper;

    public Optional<ConsentEntity> findByRedirectId(String id) {
        return this.consentRepository.findByRedirectId(id).map(this.entityMapper::toConsentEntity);
    }

    public Optional<ConsentEntity> findById(String id) {
        return this.consentRepository.findById(id).map(this.entityMapper::toConsentEntity);
    }

    public void save(ConsentEntity consentEntity) {
        this.consentRepository.save(this.entityMapper.toConsentMongoEntity(consentEntity));
    }

    public void delete(ConsentEntity internalConsent) {
        this.consentRepository.deleteById(internalConsent.getId());
    }

    public ConsentRepositoryImpl(ConsentRepositoryMongodb consentRepository, MongoEntityMapper entityMapper) {
        this.consentRepository = consentRepository;
        this.entityMapper = entityMapper;
    }
}

