/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.MlAnonymizedBookingEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.MlAnonymizedBookingRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.MlAnonymizedBookingRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class MlAnonymizedBookingRepositoryImpl
implements MlAnonymizedBookingRepositoryIf {
    private final MlAnonymizedBookingRepositoryMongodb mlAnonymizedBookingRepository;
    private final MongoEntityMapper entityMapper;

    public Optional<MlAnonymizedBookingEntity> findOne(String id) {
        return this.mlAnonymizedBookingRepository.findById(id).map(this.entityMapper::mapToMlAnonymizedBookingEntity);
    }

    public List<MlAnonymizedBookingEntity> findByUserId(String userId) {
        return this.entityMapper.mapToMlAnonymizedBookingEntities(this.mlAnonymizedBookingRepository.findByUserId(userId));
    }

    public void save(MlAnonymizedBookingEntity booking) {
        this.mlAnonymizedBookingRepository.save(this.entityMapper.mapToMlAnonymizedBookingMongoEntity(booking));
    }

    public boolean exists(String id) {
        return this.mlAnonymizedBookingRepository.existsById(id);
    }

    public MlAnonymizedBookingRepositoryImpl(MlAnonymizedBookingRepositoryMongodb mlAnonymizedBookingRepository, MongoEntityMapper entityMapper) {
        this.mlAnonymizedBookingRepository = mlAnonymizedBookingRepository;
        this.entityMapper = entityMapper;
    }
}

