/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.ContractRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.ContractRepositoryIf;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class ContractRepositoryImpl
implements ContractRepositoryIf {
    private final ContractRepositoryMongodb contractRepositoryMongodb;
    private final MongoEntityMapper entityMapper;

    public List<ContractEntity> findByUserIdAndAccountId(String userId, String accountId) {
        return this.entityMapper.mapToContractEntities(this.contractRepositoryMongodb.findByUserIdAndAccountId(userId, accountId));
    }

    public void save(List<ContractEntity> contractEntities) {
        this.contractRepositoryMongodb.insert(this.entityMapper.mapToContractMongoEntities(contractEntities));
    }

    public void deleteByAccountId(String accountId) {
        this.contractRepositoryMongodb.deleteByAccountId(accountId);
    }

    public ContractRepositoryImpl(ContractRepositoryMongodb contractRepositoryMongodb, MongoEntityMapper entityMapper) {
        this.contractRepositoryMongodb = contractRepositoryMongodb;
        this.entityMapper = entityMapper;
    }
}

