/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.mongo.entity.BankMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BankRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankRepositoryImpl
implements BankRepositoryIf {
    private final BankRepositoryMongodb bankRepositoryMongodb;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public Optional<String> findBankingUrl(String bankCode) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"bankCode").is((Object)bankCode));
        query.fields().include("bankingUrl");
        return Optional.ofNullable(this.mongoTemplate.findOne(query, BankMongoEntity.class)).map(Bank::getBankingUrl);
    }

    public Optional<BankEntity> findByBankCode(String blz) {
        return this.bankRepositoryMongodb.findByBankCode(blz).map(this.entityMapper::mapToBankEntity);
    }

    public void save(Iterable<BankEntity> bankEntities) {
        this.bankRepositoryMongodb.saveAll(this.entityMapper.mapToBankMongoEntities(bankEntities));
    }

    public void deleteAll() {
        this.bankRepositoryMongodb.deleteAll();
    }

    public void save(BankEntity bank) {
        this.bankRepositoryMongodb.save((Object)this.entityMapper.mapToBankMongoEntity(bank));
    }

    public List<BankEntity> search(String text) {
        HashSet<String> terms = new HashSet<String>(Arrays.asList(text.split(" ")));
        Criteria[] criterias = (Criteria[])terms.stream().map(s -> Criteria.where((String)"searchIndex").regex(s.toLowerCase(), "iu")).toArray(Criteria[]::new);
        return this.entityMapper.mapToBankEntities(this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria().andOperator(criterias)), BankMongoEntity.class));
    }

    public BankRepositoryImpl(BankRepositoryMongodb bankRepositoryMongodb, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.bankRepositoryMongodb = bankRepositoryMongodb;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

