/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.StandingOrderRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class StandingOrderRepositoryImpl
implements StandingOrderRepositoryIf {
    private final StandingOrderRepositoryMongodb standingOrderRepositoryMongodb;
    private final MongoEntityMapper entityMapper;

    public List<StandingOrderEntity> findByUserIdAndAccountId(String userId, String accountId) {
        return this.entityMapper.mapToStandingOrderEntities(this.standingOrderRepositoryMongodb.findByUserIdAndAccountId(userId, accountId));
    }

    public void save(List<StandingOrderEntity> standingOrders) {
        this.standingOrderRepositoryMongodb.insert(this.entityMapper.mapToStandingOrderMongoEntities(standingOrders));
    }

    public void save(StandingOrderEntity standingOrder) {
        this.standingOrderRepositoryMongodb.save((Object)this.entityMapper.mapToStandingOrderMongoEntity(standingOrder));
    }

    public void deleteByAccountId(String accountId) {
        this.standingOrderRepositoryMongodb.deleteByAccountId(accountId);
    }

    public StandingOrderRepositoryImpl(StandingOrderRepositoryMongodb standingOrderRepositoryMongodb, MongoEntityMapper entityMapper) {
        this.standingOrderRepositoryMongodb = standingOrderRepositoryMongodb;
        this.entityMapper = entityMapper;
    }
}

