/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.PaymentEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.PaymentRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.SinglePaymentRepositoryIf;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class SinglePaymentRepositoryImpl
implements SinglePaymentRepositoryIf {
    private final PaymentRepositoryMongodb paymentRepository;
    private final MongoEntityMapper entityMapper;

    public Optional<PaymentEntity> findByUserIdAndId(String userId, String id) {
        return this.paymentRepository.findByUserIdAndId(userId, id).map(this.entityMapper::mapToPaymentEntity);
    }

    public void save(PaymentEntity paymentEntity) {
        this.paymentRepository.save((Object)this.entityMapper.mapToPaymentMongoEntity(paymentEntity));
    }

    public void delete(String id) {
        this.paymentRepository.deleteById(id);
    }

    public SinglePaymentRepositoryImpl(PaymentRepositoryMongodb paymentRepository, MongoEntityMapper entityMapper) {
        this.paymentRepository = paymentRepository;
        this.entityMapper = entityMapper;
    }
}

