/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.BulkPaymentEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BulkPaymentRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BulkPaymentRepositoryIf;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BulkPaymentRepositoryImpl
implements BulkPaymentRepositoryIf {
    private final BulkPaymentRepositoryMongodb paymentRepository;
    private final MongoEntityMapper entityMapper;

    public void save(BulkPaymentEntity target) {
        this.paymentRepository.save((Object)this.entityMapper.mapToBulkPaymentMongoEntity(target));
    }

    public void delete(String id) {
        this.paymentRepository.deleteById(id);
    }

    public BulkPaymentRepositoryImpl(BulkPaymentRepositoryMongodb paymentRepository, MongoEntityMapper entityMapper) {
        this.paymentRepository = paymentRepository;
        this.entityMapper = entityMapper;
    }
}

