/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.mongo.entity.BookingMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BookingPageableRepositoryMongodb;
import de.adorsys.multibanking.mongo.repository.BookingRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BookingRepositoryImpl
implements BookingRepositoryIf {
    private final BookingRepositoryMongodb bookingRepository;
    private final BookingPageableRepositoryMongodb bookingPageableRepositoryMongodb;
    private final MongoEntityMapper entityMapper;

    public Page<BookingEntity> findPageableByUserIdAndAccountIdAndBankApi(Pageable pageable, String userId, String bankAccountId, BankApi bankApi) {
        Page<BookingMongoEntity> bookingsPage = this.bookingPageableRepositoryMongodb.findByUserIdAndAccountIdAndBankApi(pageable, userId, bankAccountId, bankApi);
        return bookingsPage.map(this.entityMapper::mapToBookingEntity);
    }

    public List<BookingEntity> findByUserIdAndAccountIdAndBankApi(String userId, String bankAccountId, BankApi bankApi) {
        return this.entityMapper.mapToBookingEntities(this.bookingRepository.findByUserIdAndAccountIdAndBankApi(userId, bankAccountId, bankApi, new Sort(Sort.Direction.DESC, new String[]{"valutaDate"})));
    }

    public Optional<BookingEntity> findByUserIdAndId(String userId, String bookingId) {
        return this.bookingRepository.findByUserIdAndId(userId, bookingId).map(this.entityMapper::mapToBookingEntity);
    }

    public List<BookingEntity> findByUserIdAndIds(String name, List<String> ids) {
        return this.entityMapper.mapToBookingEntities(this.bookingRepository.findByUserIdAndId(name, ids));
    }

    public void save(List<BookingEntity> bookingEntities) {
        List<BookingEntity> newEntities = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() == null).peek(bookingEntity -> bookingEntity.setId(UUID.randomUUID().toString())).collect(Collectors.toList());
        List<BookingEntity> existingEntities = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() != null).collect(Collectors.toList());
        try {
            this.bookingRepository.insert(this.entityMapper.mapToBookingMongoEntities(newEntities));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        this.bookingRepository.saveAll(this.entityMapper.mapToBookingMongoEntities(existingEntities));
    }

    public void deleteByAccountId(String id) {
        this.bookingRepository.deleteByAccountId(id);
    }

    public void deleteByUserIdAndAccountId(String userId, String accountId) {
        this.bookingRepository.deleteByUserIdAndAccountId(userId, accountId);
    }

    public BookingRepositoryImpl(BookingRepositoryMongodb bookingRepository, BookingPageableRepositoryMongodb bookingPageableRepositoryMongodb, MongoEntityMapper entityMapper) {
        this.bookingRepository = bookingRepository;
        this.bookingPageableRepositoryMongodb = bookingPageableRepositoryMongodb;
        this.entityMapper = entityMapper;
    }
}

