/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mongo.impl;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.mongo.entity.BankAccountMongoEntity;
import de.adorsys.multibanking.mongo.mapper.MongoEntityMapper;
import de.adorsys.multibanking.mongo.repository.BankAccountRepositoryMongodb;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class BankAccountRepositoryImpl
implements BankAccountRepositoryIf {
    private final BankAccountRepositoryMongodb bankAccountRepository;
    private final MongoTemplate mongoTemplate;
    private final MongoEntityMapper entityMapper;

    public List<BankAccountEntity> findByUserId(String userId) {
        return this.entityMapper.mapToBankAccountEntities(this.bankAccountRepository.findByUserId(userId));
    }

    public List<BankAccountEntity> findByUserIdAndBankAccessId(String userId, String bankAccessId) {
        return this.entityMapper.mapToBankAccountEntities(this.bankAccountRepository.findByUserIdAndBankAccessId(userId, bankAccessId));
    }

    public Optional<BankAccountEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccountRepository.findByUserIdAndId(userId, id).map(this.entityMapper::mapToBankAccountEntity);
    }

    public boolean exists(String accountId) {
        return this.bankAccountRepository.existsById(accountId);
    }

    public void save(List<BankAccountEntity> bankAccounts) {
        this.bankAccountRepository.saveAll(this.entityMapper.mapToBankAccountMongoEntities(bankAccounts));
    }

    public void save(BankAccountEntity bankAccount) {
        this.bankAccountRepository.save((Object)this.entityMapper.mapToBankAccountMongoEntity(bankAccount));
    }

    public BankAccount.SyncStatus getSyncStatus(String accountId) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)accountId));
        where.fields().include("syncStatus");
        BankAccountMongoEntity bankAccountEntity = (BankAccountMongoEntity)((Object)this.mongoTemplate.findOne(where, BankAccountMongoEntity.class));
        if (bankAccountEntity != null) {
            return bankAccountEntity.getSyncStatus();
        }
        return null;
    }

    public void updateSyncStatus(String accountId, BankAccount.SyncStatus syncStatus) {
        Query where = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)accountId));
        Update update = new Update().set("syncStatus", (Object)syncStatus);
        this.mongoTemplate.updateFirst(where, update, BankAccountMongoEntity.class);
    }

    public List<BankAccountEntity> deleteByBankAccess(String accessId) {
        return this.entityMapper.mapToBankAccountEntities(this.bankAccountRepository.deleteByBankAccessId(accessId));
    }

    public Optional<BankAccountEntity> findOne(String accountId) {
        return this.bankAccountRepository.findById(accountId).map(this.entityMapper::mapToBankAccountEntity);
    }

    public BankAccountRepositoryImpl(BankAccountRepositoryMongodb bankAccountRepository, MongoTemplate mongoTemplate, MongoEntityMapper entityMapper) {
        this.bankAccountRepository = bankAccountRepository;
        this.mongoTemplate = mongoTemplate;
        this.entityMapper = entityMapper;
    }
}

