/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.impl;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import de.adorsys.multibanking.repository.AnalyticsRepositoryMongodb;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Profile(value={"mongo", "fongo"})
@Service
public class AnalyticsRepositoryImpl
implements AnalyticsRepositoryIf {
    @Autowired
    private AnalyticsRepositoryMongodb analyticsRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public Optional<AccountAnalyticsEntity> findLastByUserIdAndAccountId(String userId, String bankAccountId) {
        return this.analyticsRepository.findLastByUserIdAndAccountId(userId, bankAccountId);
    }

    public Optional<LocalDateTime> findLastAnalyticsDateByUserIdAndAccountId(String userId, String bankAccountId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId).and("accountId").is((Object)bankAccountId));
        query.fields().include("analyticsDate");
        return Optional.ofNullable(this.mongoTemplate.findOne(query, AccountAnalyticsEntity.class)).map(AccountAnalyticsEntity::getAnalyticsDate);
    }

    public void save(AccountAnalyticsEntity accountAnalyticsEntity) {
        this.analyticsRepository.save(accountAnalyticsEntity);
    }

    public void deleteByAccountId(String id) {
        this.analyticsRepository.deleteByAccountId(id);
    }
}

