/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.ConsentRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.ConsentRepositoryIf;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class ConsentRepositoryImpl
implements ConsentRepositoryIf {
    private final ConsentRepositoryJpa consentRepository;
    private final JpaEntityMapper entityMapper;

    public Optional<ConsentEntity> findByRedirectId(String id) {
        return this.consentRepository.findByRedirectId(id).map(this.entityMapper::toConsentEntity);
    }

    public Optional<ConsentEntity> findById(String id) {
        return this.consentRepository.findById(id).map(this.entityMapper::toConsentEntity);
    }

    public void save(ConsentEntity consentEntity) {
        this.consentRepository.save(this.entityMapper.toConsentJpaEntity(consentEntity));
    }

    public void delete(ConsentEntity internalConsent) {
        this.consentRepository.deleteById(internalConsent.getId());
    }

    public ConsentRepositoryImpl(ConsentRepositoryJpa consentRepository, JpaEntityMapper entityMapper) {
        this.consentRepository = consentRepository;
        this.entityMapper = entityMapper;
    }
}

