/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.jpa.entity.AccountAnalyticsJpaEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.AnalyticsRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class AnalyticsRepositoryImpl
implements AnalyticsRepositoryIf {
    private final AnalyticsRepositoryJpa analyticsRepository;
    private final JpaEntityMapper entityMapper;

    public Optional<AccountAnalyticsEntity> findLastByUserIdAndAccountId(String userId, String bankAccountId) {
        return this.analyticsRepository.findLastByUserIdAndAccountId(userId, bankAccountId).map(this.entityMapper::mapToAccountAnalyticsEntity);
    }

    public Optional<LocalDateTime> findLastAnalyticsDateByUserIdAndAccountId(String userId, String bankAccountId) {
        return this.analyticsRepository.findLastAnalyticsDateByUserIdAndAccountId(userId, bankAccountId);
    }

    public void save(AccountAnalyticsEntity accountAnalyticsEntity) {
        AccountAnalyticsJpaEntity save = (AccountAnalyticsJpaEntity)this.analyticsRepository.save(this.entityMapper.mapToAccountAnalyticsJpaEntity(accountAnalyticsEntity));
        accountAnalyticsEntity.setId(save.getId().toString());
    }

    public void deleteByAccountId(String id) {
        this.analyticsRepository.deleteByAccountId(id);
    }

    public AnalyticsRepositoryImpl(AnalyticsRepositoryJpa analyticsRepository, JpaEntityMapper entityMapper) {
        this.analyticsRepository = analyticsRepository;
        this.entityMapper = entityMapper;
    }
}

