/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.jpa.entity.TanTransportTypeJpaEntity;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TanTransportTypesMapConverter
implements AttributeConverter<Map<String, List<TanTransportTypeJpaEntity>>, String> {
    private static final Logger log = LoggerFactory.getLogger(TanTransportTypesMapConverter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(Map<String, List<TanTransportTypeJpaEntity>> customerInfo) {
        try {
            return this.objectMapper.writeValueAsString(customerInfo);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<String, List<TanTransportTypeJpaEntity>> convertToEntityAttribute(String tanTransportTypesJson) {
        TypeReference<HashMap<String, List<TanTransportTypeJpaEntity>>> typeRef = new TypeReference<HashMap<String, List<TanTransportTypeJpaEntity>>>(){};
        try {
            return (Map)this.objectMapper.readValue(tanTransportTypesJson, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

