/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.BankRepositoryJpa;
import de.adorsys.multibanking.jpa.repository.HibernateSearchService;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.jpa.FullTextQuery;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;

@Profile(value={"jpa"})
@Repository
public class BankRepositoryImpl
implements BankRepositoryIf {
    private final BankRepositoryJpa bankRepository;
    private final JpaEntityMapper entityMapper;
    private final HibernateSearchService hibernateSearchService;

    public Optional<BankEntity> findByBankCode(String blz) {
        return this.bankRepository.findByBankCode(blz).map(this.entityMapper::mapToBankEntity);
    }

    public void save(Iterable<BankEntity> bankEntities) {
        this.bankRepository.saveAll(this.entityMapper.mapToBankJpaEntities(bankEntities));
    }

    public void deleteAll() {
        this.bankRepository.deleteAll();
    }

    public void save(BankEntity bank) {
        this.bankRepository.save(this.entityMapper.mapToBankJpaEntity(bank));
    }

    public List<BankEntity> search(String text) {
        FullTextQuery fullTextQuery = this.hibernateSearchService.searchBank(text);
        fullTextQuery.setMaxResults(10);
        List resultList = fullTextQuery.getResultList();
        return this.entityMapper.mapToBankEntities(resultList);
    }

    public BankRepositoryImpl(BankRepositoryJpa bankRepository, JpaEntityMapper entityMapper, HibernateSearchService hibernateSearchService) {
        this.bankRepository = bankRepository;
        this.entityMapper = entityMapper;
        this.hibernateSearchService = hibernateSearchService;
    }
}

