/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.entity;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.jpa.entity.BankLoginSettingsJpaEntity;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilterFactory;
import org.apache.lucene.analysis.ngram.EdgeNGramFilterFactory;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;

@Indexed
@Entity(name="bank")
@AnalyzerDefs(value={@AnalyzerDef(name="autocompleteEdgeAnalyzer", tokenizer=@TokenizerDef(factory=KeywordTokenizerFactory.class), filters={@TokenFilterDef(factory=PatternReplaceFilterFactory.class, params={@Parameter(name="pattern", value="([^a-zA-Z0-9\\.])"), @Parameter(name="replacement", value=" "), @Parameter(name="replace", value="all")}), @TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=StopFilterFactory.class), @TokenFilterDef(factory=EdgeNGramFilterFactory.class, params={@Parameter(name="minGramSize", value="3"), @Parameter(name="maxGramSize", value="50")})}), @AnalyzerDef(name="autocompleteNGramAnalyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=WordDelimiterFilterFactory.class), @TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=NGramFilterFactory.class, params={@Parameter(name="minGramSize", value="3"), @Parameter(name="maxGramSize", value="5")}), @TokenFilterDef(factory=PatternReplaceFilterFactory.class, params={@Parameter(name="pattern", value="([^a-zA-Z0-9\\.])"), @Parameter(name="replacement", value=" "), @Parameter(name="replace", value="all")})}), @AnalyzerDef(name="standardAnalyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=WordDelimiterFilterFactory.class), @TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=PatternReplaceFilterFactory.class, params={@Parameter(name="pattern", value="([^a-zA-Z0-9\\.])"), @Parameter(name="replacement", value=" "), @Parameter(name="replace", value="all")}), @TokenFilterDef(factory=EdgeNGramFilterFactory.class, params={@Parameter(name="minGramSize", value="4"), @Parameter(name="maxGramSize", value="8")})})})
public class BankJpaEntity {
    @Id
    @GeneratedValue
    private Long id;
    private String bankApiBankCode;
    private String bankingUrl;
    @Fields(value={@Field(name="bankCode", index=Index.YES, store=Store.YES, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer")), @Field(name="edgeNGramBankCode", index=Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer")), @Field(name="nGramBankCode", index=Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer"))})
    private String bankCode;
    private String bic;
    @Fields(value={@Field(name="name", index=Index.YES, store=Store.YES, analyze=Analyze.YES, analyzer=@Analyzer(definition="standardAnalyzer")), @Field(name="edgeNGramName", index=Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteEdgeAnalyzer")), @Field(name="nGramName", index=Index.YES, store=Store.NO, analyze=Analyze.YES, analyzer=@Analyzer(definition="autocompleteNGramAnalyzer"))})
    private String name;
    @Embedded
    private BankLoginSettingsJpaEntity loginSettings;
    private BankApi bankApi;
    private boolean redirectPreferred;

    public Long getId() {
        return this.id;
    }

    public String getBankApiBankCode() {
        return this.bankApiBankCode;
    }

    public String getBankingUrl() {
        return this.bankingUrl;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getBic() {
        return this.bic;
    }

    public String getName() {
        return this.name;
    }

    public BankLoginSettingsJpaEntity getLoginSettings() {
        return this.loginSettings;
    }

    public BankApi getBankApi() {
        return this.bankApi;
    }

    public boolean isRedirectPreferred() {
        return this.redirectPreferred;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBankApiBankCode(String bankApiBankCode) {
        this.bankApiBankCode = bankApiBankCode;
    }

    public void setBankingUrl(String bankingUrl) {
        this.bankingUrl = bankingUrl;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLoginSettings(BankLoginSettingsJpaEntity loginSettings) {
        this.loginSettings = loginSettings;
    }

    public void setBankApi(BankApi bankApi) {
        this.bankApi = bankApi;
    }

    public void setRedirectPreferred(boolean redirectPreferred) {
        this.redirectPreferred = redirectPreferred;
    }

    public String toString() {
        return "BankJpaEntity(id=" + this.getId() + ", bankApiBankCode=" + this.getBankApiBankCode() + ", bankingUrl=" + this.getBankingUrl() + ", bankCode=" + this.getBankCode() + ", bic=" + this.getBic() + ", name=" + this.getName() + ", loginSettings=" + this.getLoginSettings() + ", bankApi=" + this.getBankApi() + ", redirectPreferred=" + this.isRedirectPreferred() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankJpaEntity)) {
            return false;
        }
        BankJpaEntity other = (BankJpaEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$bankApiBankCode = this.getBankApiBankCode();
        String other$bankApiBankCode = other.getBankApiBankCode();
        if (this$bankApiBankCode == null ? other$bankApiBankCode != null : !this$bankApiBankCode.equals(other$bankApiBankCode)) {
            return false;
        }
        String this$bankingUrl = this.getBankingUrl();
        String other$bankingUrl = other.getBankingUrl();
        if (this$bankingUrl == null ? other$bankingUrl != null : !this$bankingUrl.equals(other$bankingUrl)) {
            return false;
        }
        String this$bankCode = this.getBankCode();
        String other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BankLoginSettingsJpaEntity this$loginSettings = this.getLoginSettings();
        BankLoginSettingsJpaEntity other$loginSettings = other.getLoginSettings();
        if (this$loginSettings == null ? other$loginSettings != null : !((Object)this$loginSettings).equals(other$loginSettings)) {
            return false;
        }
        BankApi this$bankApi = this.getBankApi();
        BankApi other$bankApi = other.getBankApi();
        if (this$bankApi == null ? other$bankApi != null : !this$bankApi.equals(other$bankApi)) {
            return false;
        }
        return this.isRedirectPreferred() == other.isRedirectPreferred();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankJpaEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $bankApiBankCode = this.getBankApiBankCode();
        result = result * 59 + ($bankApiBankCode == null ? 43 : $bankApiBankCode.hashCode());
        String $bankingUrl = this.getBankingUrl();
        result = result * 59 + ($bankingUrl == null ? 43 : $bankingUrl.hashCode());
        String $bankCode = this.getBankCode();
        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BankLoginSettingsJpaEntity $loginSettings = this.getLoginSettings();
        result = result * 59 + ($loginSettings == null ? 43 : ((Object)$loginSettings).hashCode());
        BankApi $bankApi = this.getBankApi();
        result = result * 59 + ($bankApi == null ? 43 : $bankApi.hashCode());
        result = result * 59 + (this.isRedirectPreferred() ? 79 : 97);
        return result;
    }
}

