/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.ContractRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.ContractRepositoryIf;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class ContractRepositoryImpl
implements ContractRepositoryIf {
    private final ContractRepositoryJpa repository;
    private final JpaEntityMapper entityMapper;

    public List<ContractEntity> findByUserIdAndAccountId(String userId, String accountId) {
        return this.entityMapper.mapToContractEntities(this.repository.findByUserIdAndAccountId(userId, accountId));
    }

    public void save(List<ContractEntity> contractEntities) {
        this.repository.saveAll(this.entityMapper.mapToContractJpaEntities(contractEntities));
    }

    public void deleteByAccountId(String accountId) {
        this.repository.deleteByAccountId(accountId);
    }

    public ContractRepositoryImpl(ContractRepositoryJpa repository, JpaEntityMapper entityMapper) {
        this.repository = repository;
        this.entityMapper = entityMapper;
    }
}

