/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.repository;

import de.adorsys.multibanking.jpa.entity.BankJpaEntity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.PhraseMatchingContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class HibernateSearchService
implements ApplicationListener<ApplicationReadyEvent> {
    private static final String NAME_EDGE_NGRAM_INDEX = "edgeNGramName";
    private static final String NAME_NGRAM_INDEX = "nGramName";
    private static final String BANKCODE_EDGE_NGRAM_INDEX = "edgeNGramBankCode";
    private static final String BANKCODE_NGRAM_INDEX = "nGramBankCode";
    private final EntityManagerFactory entityManagerFactory;
    private FullTextEntityManager fullTextEntityManager;

    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        this.reCreateIndex();
    }

    private void reCreateIndex() {
        try {
            this.fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManagerFactory.createEntityManager());
            this.fullTextEntityManager.createIndexer(new Class[]{BankJpaEntity.class}).startAndWait();
        }
        catch (InterruptedException e) {
            System.out.println("An error occurred trying to build the search index: " + e.toString());
        }
    }

    public FullTextQuery searchBank(String terms) {
        QueryBuilder queryBuilder = this.fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(BankJpaEntity.class).get();
        Query queryName = ((PhraseMatchingContext)queryBuilder.phrase().withSlop(2).onField(NAME_NGRAM_INDEX).andField(NAME_EDGE_NGRAM_INDEX).boostedTo(5.0f)).sentence(terms.toLowerCase()).createQuery();
        Query queryBankCode = ((PhraseMatchingContext)queryBuilder.phrase().withSlop(0).onField(BANKCODE_NGRAM_INDEX).andField(BANKCODE_EDGE_NGRAM_INDEX).boostedTo(1.0f)).sentence(terms.toLowerCase()).createQuery();
        Query query = queryBuilder.bool().should(queryName).should(queryBankCode).createQuery();
        return this.fullTextEntityManager.createFullTextQuery(query, new Class[]{BankJpaEntity.class});
    }

    public HibernateSearchService(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }
}

