/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.mapper;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.AnonymizedBookingEntity;
import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.BankLoginCredentialInfo;
import de.adorsys.multibanking.domain.BankLoginSettings;
import de.adorsys.multibanking.domain.BookingCategory;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingGroup;
import de.adorsys.multibanking.domain.BookingPeriod;
import de.adorsys.multibanking.domain.BookingsIndexEntity;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.Contract;
import de.adorsys.multibanking.domain.ContractEntity;
import de.adorsys.multibanking.domain.ExecutedBooking;
import de.adorsys.multibanking.domain.Rule;
import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.jpa.entity.AccountAnalyticsJpaEntity;
import de.adorsys.multibanking.jpa.entity.AnonymizedBookingJpaEntity;
import de.adorsys.multibanking.jpa.entity.BalanceEntity;
import de.adorsys.multibanking.jpa.entity.BalancesReportEntity;
import de.adorsys.multibanking.jpa.entity.BankAccessJpaEntity;
import de.adorsys.multibanking.jpa.entity.BankAccountCommonJpaEntity;
import de.adorsys.multibanking.jpa.entity.BankAccountJpaEntity;
import de.adorsys.multibanking.jpa.entity.BankJpaEntity;
import de.adorsys.multibanking.jpa.entity.BankLoginCredentialInfoJpaEntity;
import de.adorsys.multibanking.jpa.entity.BankLoginSettingsJpaEntity;
import de.adorsys.multibanking.jpa.entity.BookingCategoryJpaEntity;
import de.adorsys.multibanking.jpa.entity.BookingGroupJpaEntity;
import de.adorsys.multibanking.jpa.entity.BookingJpaEntity;
import de.adorsys.multibanking.jpa.entity.BookingPeriodJpaEntity;
import de.adorsys.multibanking.jpa.entity.BookingsIndexJpaEntity;
import de.adorsys.multibanking.jpa.entity.ConsentJpaEntity;
import de.adorsys.multibanking.jpa.entity.ContractJpaEntity;
import de.adorsys.multibanking.jpa.entity.ExecutedBookingJpaEntity;
import de.adorsys.multibanking.jpa.entity.RuleJpaEntity;
import de.adorsys.multibanking.jpa.entity.TanTransportTypeJpaEntity;
import de.adorsys.multibanking.jpa.entity.UserJpaEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class JpaEntityMapperImpl
implements JpaEntityMapper {
    @Override
    public AccountAnalyticsEntity mapToAccountAnalyticsEntity(AccountAnalyticsJpaEntity accountAnalyticsEntity) {
        if (accountAnalyticsEntity == null) {
            return null;
        }
        AccountAnalyticsEntity accountAnalyticsEntity1 = new AccountAnalyticsEntity();
        if (accountAnalyticsEntity.getId() != null) {
            accountAnalyticsEntity1.setId(String.valueOf(accountAnalyticsEntity.getId()));
        }
        accountAnalyticsEntity1.setAccountId(accountAnalyticsEntity.getAccountId());
        accountAnalyticsEntity1.setUserId(accountAnalyticsEntity.getUserId());
        accountAnalyticsEntity1.setAnalyticsDate(accountAnalyticsEntity.getAnalyticsDate());
        accountAnalyticsEntity1.setBookingGroups(this.bookingGroupJpaEntityListToBookingGroupList(accountAnalyticsEntity.getBookingGroups()));
        return accountAnalyticsEntity1;
    }

    @Override
    public BookingPeriod mapToBookingPeriodEntity(BookingPeriodJpaEntity bookingPeriod) {
        if (bookingPeriod == null) {
            return null;
        }
        BookingPeriod.BookingPeriodBuilder bookingPeriod1 = BookingPeriod.builder();
        bookingPeriod1.start(bookingPeriod.getPeriodStart());
        bookingPeriod1.end(bookingPeriod.getPeriodEnd());
        bookingPeriod1.amount(bookingPeriod.getAmount());
        bookingPeriod1.bookings(this.executedBookingJpaEntityListToExecutedBookingList(bookingPeriod.getBookings()));
        return bookingPeriod1.build();
    }

    @Override
    public AccountAnalyticsJpaEntity mapToAccountAnalyticsJpaEntity(AccountAnalyticsEntity accountAnalyticsEntity) {
        if (accountAnalyticsEntity == null) {
            return null;
        }
        AccountAnalyticsJpaEntity accountAnalyticsJpaEntity = new AccountAnalyticsJpaEntity();
        if (accountAnalyticsEntity.getId() != null) {
            accountAnalyticsJpaEntity.setId(Long.parseLong(accountAnalyticsEntity.getId()));
        }
        accountAnalyticsJpaEntity.setAccountId(accountAnalyticsEntity.getAccountId());
        accountAnalyticsJpaEntity.setUserId(accountAnalyticsEntity.getUserId());
        accountAnalyticsJpaEntity.setAnalyticsDate(accountAnalyticsEntity.getAnalyticsDate());
        accountAnalyticsJpaEntity.setBookingGroups(this.bookingGroupListToBookingGroupJpaEntityList(accountAnalyticsEntity.getBookingGroups()));
        return accountAnalyticsJpaEntity;
    }

    @Override
    public ContractJpaEntity mapToContractJpaEntity(ContractEntity contract) {
        if (contract == null) {
            return null;
        }
        ContractJpaEntity contractJpaEntity = new ContractJpaEntity();
        if (contract.getId() != null) {
            contractJpaEntity.setId(Long.parseLong(contract.getId()));
        }
        contractJpaEntity.setUserId(contract.getUserId());
        contractJpaEntity.setAccountId(contract.getAccountId());
        contractJpaEntity.setLogo(contract.getLogo());
        contractJpaEntity.setHomepage(contract.getHomepage());
        contractJpaEntity.setHotline(contract.getHotline());
        contractJpaEntity.setEmail(contract.getEmail());
        contractJpaEntity.setMandateReference(contract.getMandateReference());
        contractJpaEntity.setInterval(contract.getInterval());
        contractJpaEntity.setCancelled(contract.isCancelled());
        contractJpaEntity.setAmount(contract.getAmount());
        contractJpaEntity.setMainCategory(contract.getMainCategory());
        contractJpaEntity.setSubCategory(contract.getSubCategory());
        contractJpaEntity.setSpecification(contract.getSpecification());
        contractJpaEntity.setProvider(contract.getProvider());
        return contractJpaEntity;
    }

    @Override
    public ContractJpaEntity mapToContractJpaEntity(Contract contract) {
        if (contract == null) {
            return null;
        }
        ContractJpaEntity contractJpaEntity = new ContractJpaEntity();
        contractJpaEntity.setLogo(contract.getLogo());
        contractJpaEntity.setHomepage(contract.getHomepage());
        contractJpaEntity.setHotline(contract.getHotline());
        contractJpaEntity.setEmail(contract.getEmail());
        contractJpaEntity.setMandateReference(contract.getMandateReference());
        contractJpaEntity.setInterval(contract.getInterval());
        contractJpaEntity.setCancelled(contract.isCancelled());
        contractJpaEntity.setAmount(contract.getAmount());
        contractJpaEntity.setMainCategory(contract.getMainCategory());
        contractJpaEntity.setSubCategory(contract.getSubCategory());
        contractJpaEntity.setSpecification(contract.getSpecification());
        contractJpaEntity.setProvider(contract.getProvider());
        return contractJpaEntity;
    }

    @Override
    public BookingGroupJpaEntity mapToBookingGroupJpaEntity(BookingGroup bookingGroup) {
        if (bookingGroup == null) {
            return null;
        }
        BookingGroupJpaEntity bookingGroupJpaEntity = new BookingGroupJpaEntity();
        bookingGroupJpaEntity.setType(this.typeToType1(bookingGroup.getType()));
        bookingGroupJpaEntity.setName(bookingGroup.getName());
        bookingGroupJpaEntity.setSalaryWage(bookingGroup.isSalaryWage());
        bookingGroupJpaEntity.setMainCategory(bookingGroup.getMainCategory());
        bookingGroupJpaEntity.setSubCategory(bookingGroup.getSubCategory());
        bookingGroupJpaEntity.setSpecification(bookingGroup.getSpecification());
        bookingGroupJpaEntity.setOtherAccount(bookingGroup.getOtherAccount());
        bookingGroupJpaEntity.setAmount(bookingGroup.getAmount());
        bookingGroupJpaEntity.setBookingPeriods(this.bookingPeriodListToBookingPeriodJpaEntityList(bookingGroup.getBookingPeriods()));
        bookingGroupJpaEntity.setContract(this.mapToContractJpaEntity(bookingGroup.getContract()));
        return bookingGroupJpaEntity;
    }

    @Override
    public BookingPeriodJpaEntity mapToBookingPeriodJpaEntity(BookingPeriod bookingPeriod) {
        if (bookingPeriod == null) {
            return null;
        }
        BookingPeriodJpaEntity bookingPeriodJpaEntity = new BookingPeriodJpaEntity();
        bookingPeriodJpaEntity.setPeriodStart(bookingPeriod.getStart());
        bookingPeriodJpaEntity.setPeriodEnd(bookingPeriod.getEnd());
        bookingPeriodJpaEntity.setAmount(bookingPeriod.getAmount());
        bookingPeriodJpaEntity.setBookings(this.executedBookingListToExecutedBookingJpaEntityList(bookingPeriod.getBookings()));
        return bookingPeriodJpaEntity;
    }

    @Override
    public ExecutedBookingJpaEntity mapToExecutedBookingJpaEntity(ExecutedBooking executedBooking) {
        if (executedBooking == null) {
            return null;
        }
        ExecutedBookingJpaEntity executedBookingJpaEntity = new ExecutedBookingJpaEntity();
        executedBookingJpaEntity.setBookingId(executedBooking.getBookingId());
        executedBookingJpaEntity.setExecutionDate(executedBooking.getExecutionDate());
        executedBookingJpaEntity.setExecuted(executedBooking.isExecuted());
        return executedBookingJpaEntity;
    }

    @Override
    public List<AnonymizedBookingJpaEntity> mapToAnonymizedBookingJpaEntities(List<AnonymizedBookingEntity> bookingEntities) {
        if (bookingEntities == null) {
            return null;
        }
        ArrayList<AnonymizedBookingJpaEntity> list = new ArrayList<AnonymizedBookingJpaEntity>(bookingEntities.size());
        for (AnonymizedBookingEntity anonymizedBookingEntity : bookingEntities) {
            list.add(this.anonymizedBookingEntityToAnonymizedBookingJpaEntity(anonymizedBookingEntity));
        }
        return list;
    }

    @Override
    public BankAccessEntity mapToBankAccessEntity(BankAccessJpaEntity entity) {
        if (entity == null) {
            return null;
        }
        BankAccessEntity bankAccessEntity = new BankAccessEntity();
        bankAccessEntity.setConsentId(entity.getConsentId());
        bankAccessEntity.setBankName(entity.getBankName());
        bankAccessEntity.setBankCode(entity.getBankCode());
        bankAccessEntity.setIban(entity.getIban());
        bankAccessEntity.setTanTransportTypes(this.stringListHashMapToBankApiListMap(entity.getTanTransportTypes()));
        bankAccessEntity.setHbciPassportState(entity.getHbciPassportState());
        Map<BankApi, String> map1 = entity.getExternalIdMap();
        if (map1 != null) {
            bankAccessEntity.setExternalIdMap(new HashMap<BankApi, String>(map1));
        }
        if (entity.getId() != null) {
            bankAccessEntity.setId(String.valueOf(entity.getId()));
        }
        bankAccessEntity.setUserId(entity.getUserId());
        bankAccessEntity.setTemporary(entity.isTemporary());
        bankAccessEntity.setStoreBookings(entity.isStoreBookings());
        bankAccessEntity.setCategorizeBookings(entity.isCategorizeBookings());
        bankAccessEntity.setStoreAnalytics(entity.isStoreAnalytics());
        bankAccessEntity.setStoreAnonymizedBookings(entity.isStoreAnonymizedBookings());
        bankAccessEntity.setProvideDataForMachineLearning(entity.isProvideDataForMachineLearning());
        return bankAccessEntity;
    }

    @Override
    public List<TanTransportType> mapToTanTransportTypeList(List<TanTransportTypeJpaEntity> value) {
        if (value == null) {
            return null;
        }
        ArrayList<TanTransportType> list = new ArrayList<TanTransportType>(value.size());
        for (TanTransportTypeJpaEntity tanTransportTypeJpaEntity : value) {
            list.add(this.mapToTanTransportType(tanTransportTypeJpaEntity));
        }
        return list;
    }

    @Override
    public TanTransportType mapToTanTransportType(TanTransportTypeJpaEntity value) {
        if (value == null) {
            return null;
        }
        TanTransportType.TanTransportTypeBuilder tanTransportType = TanTransportType.builder();
        tanTransportType.id(value.getId());
        tanTransportType.name(value.getName());
        tanTransportType.medium(value.getMedium());
        tanTransportType.inputInfo(value.getInputInfo());
        tanTransportType.type(value.getType());
        return tanTransportType.build();
    }

    @Override
    public List<BankAccessEntity> mapToBankAccessEntities(List<BankAccessJpaEntity> byUserId) {
        if (byUserId == null) {
            return null;
        }
        ArrayList<BankAccessEntity> list = new ArrayList<BankAccessEntity>(byUserId.size());
        for (BankAccessJpaEntity bankAccessJpaEntity : byUserId) {
            list.add(this.mapToBankAccessEntity(bankAccessJpaEntity));
        }
        return list;
    }

    @Override
    public BankAccessJpaEntity mapToBankAccessJpaEntity(BankAccessEntity bankAccess) {
        if (bankAccess == null) {
            return null;
        }
        BankAccessJpaEntity bankAccessJpaEntity = new BankAccessJpaEntity();
        if (bankAccess.getId() != null) {
            bankAccessJpaEntity.setId(Long.parseLong(bankAccess.getId()));
        }
        bankAccessJpaEntity.setUserId(bankAccess.getUserId());
        bankAccessJpaEntity.setConsentId(bankAccess.getConsentId());
        bankAccessJpaEntity.setTemporary(bankAccess.isTemporary());
        bankAccessJpaEntity.setStoreBookings(bankAccess.isStoreBookings());
        bankAccessJpaEntity.setCategorizeBookings(bankAccess.isCategorizeBookings());
        bankAccessJpaEntity.setStoreAnalytics(bankAccess.isStoreAnalytics());
        bankAccessJpaEntity.setStoreAnonymizedBookings(bankAccess.isStoreAnonymizedBookings());
        bankAccessJpaEntity.setProvideDataForMachineLearning(bankAccess.isProvideDataForMachineLearning());
        bankAccessJpaEntity.setBankName(bankAccess.getBankName());
        bankAccessJpaEntity.setBankCode(bankAccess.getBankCode());
        bankAccessJpaEntity.setIban(bankAccess.getIban());
        bankAccessJpaEntity.setHbciPassportState(bankAccess.getHbciPassportState());
        bankAccessJpaEntity.setTanTransportTypes(this.bankApiListMapToStringListHashMap(bankAccess.getTanTransportTypes()));
        Map map = bankAccess.getExternalIdMap();
        if (map != null) {
            bankAccessJpaEntity.setExternalIdMap(new HashMap<BankApi, String>(map));
        }
        return bankAccessJpaEntity;
    }

    @Override
    public List<TanTransportTypeJpaEntity> mapToTanTransportTypeJpaEntityList(List<TanTransportType> value) {
        if (value == null) {
            return null;
        }
        ArrayList<TanTransportTypeJpaEntity> list = new ArrayList<TanTransportTypeJpaEntity>(value.size());
        for (TanTransportType tanTransportType : value) {
            list.add(this.tanTransportTypeToTanTransportTypeJpaEntity(tanTransportType));
        }
        return list;
    }

    @Override
    public List<BankAccountEntity> mapToBankAccountEntities(List<BankAccountJpaEntity> byUserId) {
        if (byUserId == null) {
            return null;
        }
        ArrayList<BankAccountEntity> list = new ArrayList<BankAccountEntity>(byUserId.size());
        for (BankAccountJpaEntity bankAccountJpaEntity : byUserId) {
            list.add(this.mapToBankAccountEntity(bankAccountJpaEntity));
        }
        return list;
    }

    @Override
    public BankAccountEntity mapToBankAccountEntity(BankAccountJpaEntity bankAccountJpaEntity) {
        if (bankAccountJpaEntity == null) {
            return null;
        }
        BankAccountEntity bankAccountEntity = new BankAccountEntity();
        bankAccountEntity.setBalances(this.balancesReportEntityToBalancesReport(bankAccountJpaEntity.getBalances()));
        bankAccountEntity.setCountry(bankAccountJpaEntity.getCountry());
        bankAccountEntity.setBlz(bankAccountJpaEntity.getBlz());
        bankAccountEntity.setAccountNumber(bankAccountJpaEntity.getAccountNumber());
        bankAccountEntity.setType(bankAccountJpaEntity.getType());
        bankAccountEntity.setCurrency(bankAccountJpaEntity.getCurrency());
        bankAccountEntity.setName(bankAccountJpaEntity.getName());
        bankAccountEntity.setBankName(bankAccountJpaEntity.getBankName());
        bankAccountEntity.setBic(bankAccountJpaEntity.getBic());
        bankAccountEntity.setIban(bankAccountJpaEntity.getIban());
        bankAccountEntity.setOwner(bankAccountJpaEntity.getOwner());
        Map<BankApi, String> map = bankAccountJpaEntity.getExternalIdMap();
        if (map != null) {
            bankAccountEntity.setExternalIdMap(new HashMap<BankApi, String>(map));
        }
        bankAccountEntity.setSyncStatus(bankAccountJpaEntity.getSyncStatus());
        bankAccountEntity.setLastSync(bankAccountJpaEntity.getLastSync());
        if (bankAccountJpaEntity.getId() != null) {
            bankAccountEntity.setId(String.valueOf(bankAccountJpaEntity.getId()));
        }
        bankAccountEntity.setBankAccessId(bankAccountJpaEntity.getBankAccessId());
        bankAccountEntity.setUserId(bankAccountJpaEntity.getUserId());
        return bankAccountEntity;
    }

    @Override
    public List<BankAccountJpaEntity> mapToBankAccountJpaEntities(List<BankAccountEntity> bankAccounts) {
        if (bankAccounts == null) {
            return null;
        }
        ArrayList<BankAccountJpaEntity> list = new ArrayList<BankAccountJpaEntity>(bankAccounts.size());
        for (BankAccountEntity bankAccountEntity : bankAccounts) {
            list.add(this.mapToBankAccountJpaEntity(bankAccountEntity));
        }
        return list;
    }

    @Override
    public BankAccountJpaEntity mapToBankAccountJpaEntity(BankAccountEntity bankAccount) {
        if (bankAccount == null) {
            return null;
        }
        BankAccountJpaEntity bankAccountJpaEntity = new BankAccountJpaEntity();
        bankAccountJpaEntity.setOwner(bankAccount.getOwner());
        bankAccountJpaEntity.setCountry(bankAccount.getCountry());
        bankAccountJpaEntity.setBlz(bankAccount.getBlz());
        bankAccountJpaEntity.setBankName(bankAccount.getBankName());
        bankAccountJpaEntity.setAccountNumber(bankAccount.getAccountNumber());
        bankAccountJpaEntity.setType(bankAccount.getType());
        bankAccountJpaEntity.setCurrency(bankAccount.getCurrency());
        bankAccountJpaEntity.setName(bankAccount.getName());
        bankAccountJpaEntity.setBic(bankAccount.getBic());
        bankAccountJpaEntity.setIban(bankAccount.getIban());
        bankAccountJpaEntity.setSyncStatus(bankAccount.getSyncStatus());
        bankAccountJpaEntity.setLastSync(bankAccount.getLastSync());
        if (bankAccount.getId() != null) {
            bankAccountJpaEntity.setId(Long.parseLong(bankAccount.getId()));
        }
        bankAccountJpaEntity.setBankAccessId(bankAccount.getBankAccessId());
        bankAccountJpaEntity.setUserId(bankAccount.getUserId());
        Map map = bankAccount.getExternalIdMap();
        if (map != null) {
            bankAccountJpaEntity.setExternalIdMap(new HashMap<BankApi, String>(map));
        }
        bankAccountJpaEntity.setBalances(this.balancesReportToBalancesReportEntity(bankAccount.getBalances()));
        return bankAccountJpaEntity;
    }

    @Override
    public BankEntity mapToBankEntity(BankJpaEntity bankJpaEntity) {
        if (bankJpaEntity == null) {
            return null;
        }
        BankEntity bankEntity = new BankEntity();
        bankEntity.setLoginSettings(this.bankLoginSettingsJpaEntityToBankLoginSettings(bankJpaEntity.getLoginSettings()));
        bankEntity.setBankCode(bankJpaEntity.getBankCode());
        bankEntity.setBankApiBankCode(bankJpaEntity.getBankApiBankCode());
        bankEntity.setBic(bankJpaEntity.getBic());
        bankEntity.setName(bankJpaEntity.getName());
        bankEntity.setBankApi(bankJpaEntity.getBankApi());
        bankEntity.setRedirectPreferred(bankJpaEntity.isRedirectPreferred());
        if (bankJpaEntity.getId() != null) {
            bankEntity.setId(String.valueOf(bankJpaEntity.getId()));
        }
        return bankEntity;
    }

    @Override
    public List<BankJpaEntity> mapToBankJpaEntities(Iterable<BankEntity> bankEntities) {
        if (bankEntities == null) {
            return null;
        }
        ArrayList<BankJpaEntity> list = new ArrayList<BankJpaEntity>();
        for (BankEntity bankEntity : bankEntities) {
            list.add(this.mapToBankJpaEntity(bankEntity));
        }
        return list;
    }

    @Override
    public BankJpaEntity mapToBankJpaEntity(BankEntity bank) {
        if (bank == null) {
            return null;
        }
        BankJpaEntity bankJpaEntity = new BankJpaEntity();
        bankJpaEntity.setLoginSettings(this.bankLoginSettingsToBankLoginSettingsJpaEntity(bank.getLoginSettings()));
        if (bank.getId() != null) {
            bankJpaEntity.setId(Long.parseLong(bank.getId()));
        }
        bankJpaEntity.setBankApiBankCode(bank.getBankApiBankCode());
        bankJpaEntity.setBankCode(bank.getBankCode());
        bankJpaEntity.setBic(bank.getBic());
        bankJpaEntity.setName(bank.getName());
        bankJpaEntity.setBankApi(bank.getBankApi());
        bankJpaEntity.setRedirectPreferred(bank.isRedirectPreferred());
        return bankJpaEntity;
    }

    @Override
    public BookingEntity mapToBookingEntity(BookingJpaEntity bookingJpaEntity) {
        if (bookingJpaEntity == null) {
            return null;
        }
        BookingEntity bookingEntity = new BookingEntity();
        bookingEntity.setExternalId(bookingJpaEntity.getExternalId());
        bookingEntity.setOtherAccount(this.bankAccountCommonJpaEntityToBankAccount(bookingJpaEntity.getOtherAccount()));
        bookingEntity.setValutaDate(bookingJpaEntity.getValutaDate());
        bookingEntity.setBookingDate(bookingJpaEntity.getBookingDate());
        bookingEntity.setAmount(bookingJpaEntity.getAmount());
        bookingEntity.setCurrency(bookingJpaEntity.getCurrency());
        bookingEntity.setReversal(bookingJpaEntity.isReversal());
        bookingEntity.setBalance(bookingJpaEntity.getBalance());
        bookingEntity.setCustomerRef(bookingJpaEntity.getCustomerRef());
        bookingEntity.setInstRef(bookingJpaEntity.getInstRef());
        bookingEntity.setOrigValue(bookingJpaEntity.getOrigValue());
        bookingEntity.setChargeValue(bookingJpaEntity.getChargeValue());
        bookingEntity.setText(bookingJpaEntity.getText());
        bookingEntity.setAdditional(bookingJpaEntity.getAdditional());
        bookingEntity.setPrimanota(bookingJpaEntity.getPrimanota());
        bookingEntity.setUsage(bookingJpaEntity.getUsage());
        bookingEntity.setAddkey(bookingJpaEntity.getAddkey());
        bookingEntity.setSepa(bookingJpaEntity.isSepa());
        bookingEntity.setCamt(bookingJpaEntity.isCamt());
        bookingEntity.setStandingOrder(bookingJpaEntity.isStandingOrder());
        bookingEntity.setCreditorId(bookingJpaEntity.getCreditorId());
        bookingEntity.setMandateReference(bookingJpaEntity.getMandateReference());
        bookingEntity.setBankApi(bookingJpaEntity.getBankApi());
        bookingEntity.setBookingCategory(this.bookingCategoryJpaEntityToBookingCategory(bookingJpaEntity.getBookingCategory()));
        bookingEntity.setTransactionCode(bookingJpaEntity.getTransactionCode());
        bookingEntity.setId(bookingJpaEntity.getId());
        bookingEntity.setAccountId(bookingJpaEntity.getAccountId());
        bookingEntity.setUserId(bookingJpaEntity.getUserId());
        return bookingEntity;
    }

    @Override
    public List<BookingEntity> mapToBookingEntities(List<BookingJpaEntity> valutaDate) {
        if (valutaDate == null) {
            return null;
        }
        ArrayList<BookingEntity> list = new ArrayList<BookingEntity>(valutaDate.size());
        for (BookingJpaEntity bookingJpaEntity : valutaDate) {
            list.add(this.mapToBookingEntity(bookingJpaEntity));
        }
        return list;
    }

    @Override
    public List<BookingJpaEntity> mapToBookingJpaEntities(List<BookingEntity> newEntities) {
        if (newEntities == null) {
            return null;
        }
        ArrayList<BookingJpaEntity> list = new ArrayList<BookingJpaEntity>(newEntities.size());
        for (BookingEntity bookingEntity : newEntities) {
            list.add(this.bookingEntityToBookingJpaEntity(bookingEntity));
        }
        return list;
    }

    @Override
    public BookingCategoryJpaEntity mapToBookingCategoryJpaEntity(BookingCategory bookingCategory) {
        if (bookingCategory == null) {
            return null;
        }
        BookingCategoryJpaEntity bookingCategoryJpaEntity = new BookingCategoryJpaEntity();
        bookingCategoryJpaEntity.setLogo(bookingCategory.getLogo());
        bookingCategoryJpaEntity.setHomepage(bookingCategory.getHomepage());
        bookingCategoryJpaEntity.setHotline(bookingCategory.getHotline());
        bookingCategoryJpaEntity.setEmail(bookingCategory.getEmail());
        bookingCategoryJpaEntity.setMandateReference(bookingCategory.getMandateReference());
        bookingCategoryJpaEntity.setInterval(bookingCategory.getInterval());
        bookingCategoryJpaEntity.setCancelled(bookingCategory.isCancelled());
        bookingCategoryJpaEntity.setAmount(bookingCategory.getAmount());
        bookingCategoryJpaEntity.setMainCategory(bookingCategory.getMainCategory());
        bookingCategoryJpaEntity.setSubCategory(bookingCategory.getSubCategory());
        bookingCategoryJpaEntity.setSpecification(bookingCategory.getSpecification());
        bookingCategoryJpaEntity.setProvider(bookingCategory.getProvider());
        Set set = bookingCategory.getRules();
        if (set != null) {
            bookingCategoryJpaEntity.setRules(new ArrayList<String>(set));
        }
        bookingCategoryJpaEntity.setReceiver(bookingCategory.getReceiver());
        Map map = bookingCategory.getCustom();
        if (map != null) {
            bookingCategoryJpaEntity.setCustom(new HashMap<String, String>(map));
        }
        return bookingCategoryJpaEntity;
    }

    @Override
    public List<RuleEntity> mapToRuleEntities(List<RuleJpaEntity> byUserId) {
        if (byUserId == null) {
            return null;
        }
        ArrayList<RuleEntity> list = new ArrayList<RuleEntity>(byUserId.size());
        for (RuleJpaEntity ruleJpaEntity : byUserId) {
            list.add(this.mapToRuleEntity(ruleJpaEntity));
        }
        return list;
    }

    @Override
    public RuleEntity mapToRuleEntity(RuleJpaEntity ruleJpaEntity) {
        if (ruleJpaEntity == null) {
            return null;
        }
        RuleEntity ruleEntity = new RuleEntity();
        ruleEntity.setRuleId(ruleJpaEntity.getRuleId());
        ruleEntity.setMainCategory(ruleJpaEntity.getMainCategory());
        ruleEntity.setSubCategory(ruleJpaEntity.getSubCategory());
        ruleEntity.setSpecification(ruleJpaEntity.getSpecification());
        ruleEntity.setSimilarityMatchType(this.sIMILARITY_MATCH_TYPEToSIMILARITY_MATCH_TYPE(ruleJpaEntity.getSimilarityMatchType()));
        ruleEntity.setCreditorId(ruleJpaEntity.getCreditorId());
        ruleEntity.setExpression(ruleJpaEntity.getExpression());
        ruleEntity.setReceiver(ruleJpaEntity.getReceiver());
        ruleEntity.setRuleType(ruleJpaEntity.getRuleType());
        ruleEntity.setLogo(ruleJpaEntity.getLogo());
        ruleEntity.setHotline(ruleJpaEntity.getHotline());
        ruleEntity.setHomepage(ruleJpaEntity.getHomepage());
        ruleEntity.setEmail(ruleJpaEntity.getEmail());
        ruleEntity.setIncoming(ruleJpaEntity.isIncoming());
        ruleEntity.setId(ruleJpaEntity.getId());
        ruleEntity.setUserId(ruleJpaEntity.getUserId());
        List<String> list = ruleJpaEntity.getSearchIndex();
        if (list != null) {
            ruleEntity.setSearchIndex(new ArrayList<String>(list));
        }
        return ruleEntity;
    }

    @Override
    public RuleJpaEntity mapToRuleJpaEntity(RuleEntity ruleEntity) {
        if (ruleEntity == null) {
            return null;
        }
        RuleJpaEntity ruleJpaEntity = new RuleJpaEntity();
        ruleJpaEntity.setId(ruleEntity.getId());
        ruleJpaEntity.setUserId(ruleEntity.getUserId());
        List list = ruleEntity.getSearchIndex();
        if (list != null) {
            ruleJpaEntity.setSearchIndex(new ArrayList<String>(list));
        }
        ruleJpaEntity.setRuleId(ruleEntity.getRuleId());
        ruleJpaEntity.setMainCategory(ruleEntity.getMainCategory());
        ruleJpaEntity.setSubCategory(ruleEntity.getSubCategory());
        ruleJpaEntity.setSpecification(ruleEntity.getSpecification());
        ruleJpaEntity.setSimilarityMatchType(this.sIMILARITY_MATCH_TYPEToSIMILARITY_MATCH_TYPE1(ruleEntity.getSimilarityMatchType()));
        ruleJpaEntity.setCreditorId(ruleEntity.getCreditorId());
        ruleJpaEntity.setExpression(ruleEntity.getExpression());
        ruleJpaEntity.setReceiver(ruleEntity.getReceiver());
        ruleJpaEntity.setRuleType(ruleEntity.getRuleType());
        ruleJpaEntity.setLogo(ruleEntity.getLogo());
        ruleJpaEntity.setHotline(ruleEntity.getHotline());
        ruleJpaEntity.setHomepage(ruleEntity.getHomepage());
        ruleJpaEntity.setEmail(ruleEntity.getEmail());
        ruleJpaEntity.setIncoming(ruleEntity.isIncoming());
        return ruleJpaEntity;
    }

    @Override
    public BookingsIndexJpaEntity mapToBookingsIndexJpaEntity(BookingsIndexEntity entity) {
        if (entity == null) {
            return null;
        }
        BookingsIndexJpaEntity bookingsIndexJpaEntity = new BookingsIndexJpaEntity();
        if (entity.getId() != null) {
            bookingsIndexJpaEntity.setId(Long.parseLong(entity.getId()));
        }
        bookingsIndexJpaEntity.setAccountId(entity.getAccountId());
        bookingsIndexJpaEntity.setUserId(entity.getUserId());
        Map map = entity.getBookingIdSearchList();
        if (map != null) {
            bookingsIndexJpaEntity.setBookingIdSearchList(new HashMap<String, List<String>>(map));
        }
        return bookingsIndexJpaEntity;
    }

    @Override
    public BookingsIndexEntity mapToBookingsIndexEntity(BookingsIndexJpaEntity bookingsIndexJpaEntity) {
        if (bookingsIndexJpaEntity == null) {
            return null;
        }
        BookingsIndexEntity bookingsIndexEntity = new BookingsIndexEntity();
        if (bookingsIndexJpaEntity.getId() != null) {
            bookingsIndexEntity.setId(String.valueOf(bookingsIndexJpaEntity.getId()));
        }
        bookingsIndexEntity.setAccountId(bookingsIndexJpaEntity.getAccountId());
        bookingsIndexEntity.setUserId(bookingsIndexJpaEntity.getUserId());
        Map<String, List<String>> map = bookingsIndexJpaEntity.getBookingIdSearchList();
        if (map != null) {
            bookingsIndexEntity.setBookingIdSearchList(new HashMap<String, List<String>>(map));
        }
        return bookingsIndexEntity;
    }

    @Override
    public List<ContractEntity> mapToContractEntities(List<ContractJpaEntity> byUserIdAndAccountId) {
        if (byUserIdAndAccountId == null) {
            return null;
        }
        ArrayList<ContractEntity> list = new ArrayList<ContractEntity>(byUserIdAndAccountId.size());
        for (ContractJpaEntity contractJpaEntity : byUserIdAndAccountId) {
            list.add(this.contractJpaEntityToContractEntity(contractJpaEntity));
        }
        return list;
    }

    @Override
    public List<ContractJpaEntity> mapToContractJpaEntities(List<ContractEntity> contractEntities) {
        if (contractEntities == null) {
            return null;
        }
        ArrayList<ContractJpaEntity> list = new ArrayList<ContractJpaEntity>(contractEntities.size());
        for (ContractEntity contractEntity : contractEntities) {
            list.add(this.mapToContractJpaEntity(contractEntity));
        }
        return list;
    }

    @Override
    public UserEntity mapToUserEntity(UserJpaEntity userJpaEntity) {
        if (userJpaEntity == null) {
            return null;
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userJpaEntity.getId());
        userEntity.setExpireUser(userJpaEntity.getExpireUser());
        userEntity.setRulesLastChangeDate(userJpaEntity.getRulesLastChangeDate());
        List<BankApiUser> list = userJpaEntity.getApiUser();
        if (list != null) {
            userEntity.setApiUser(new ArrayList<BankApiUser>(list));
        }
        return userEntity;
    }

    @Override
    public UserJpaEntity mapToUserJpaEntity(UserEntity userEntity) {
        if (userEntity == null) {
            return null;
        }
        UserJpaEntity userJpaEntity = new UserJpaEntity();
        userJpaEntity.setId(userEntity.getId());
        userJpaEntity.setExpireUser(userEntity.getExpireUser());
        userJpaEntity.setRulesLastChangeDate(userEntity.getRulesLastChangeDate());
        List list = userEntity.getApiUser();
        if (list != null) {
            userJpaEntity.setApiUser(new ArrayList<BankApiUser>(list));
        }
        return userJpaEntity;
    }

    @Override
    public List<BankEntity> mapToBankEntities(List<BankJpaEntity> bankJpaEntities) {
        if (bankJpaEntities == null) {
            return null;
        }
        ArrayList<BankEntity> list = new ArrayList<BankEntity>(bankJpaEntities.size());
        for (BankJpaEntity bankJpaEntity : bankJpaEntities) {
            list.add(this.mapToBankEntity(bankJpaEntity));
        }
        return list;
    }

    @Override
    public List<BookingsIndexEntity> mapToBookingsIndexEntities(List<BookingsIndexJpaEntity> bookingsIndexJpaEntities) {
        if (bookingsIndexJpaEntities == null) {
            return null;
        }
        ArrayList<BookingsIndexEntity> list = new ArrayList<BookingsIndexEntity>(bookingsIndexJpaEntities.size());
        for (BookingsIndexJpaEntity bookingsIndexJpaEntity : bookingsIndexJpaEntities) {
            list.add(this.mapToBookingsIndexEntity(bookingsIndexJpaEntity));
        }
        return list;
    }

    @Override
    public ConsentEntity toConsentEntity(ConsentJpaEntity consentJpaEntity) {
        if (consentJpaEntity == null) {
            return null;
        }
        ConsentEntity consentEntity = new ConsentEntity();
        consentEntity.setId(consentJpaEntity.getId());
        consentEntity.setAuthorisationId(consentJpaEntity.getAuthorisationId());
        consentEntity.setRedirectId(consentJpaEntity.getRedirectId());
        consentEntity.setTemporary(consentJpaEntity.isTemporary());
        consentEntity.setBankApi(consentJpaEntity.getBankApi());
        consentEntity.setPsuAccountIban(consentJpaEntity.getPsuAccountIban());
        consentEntity.setBankApiConsentData(consentJpaEntity.getBankApiConsentData());
        return consentEntity;
    }

    @Override
    public ConsentJpaEntity toConsentJpaEntity(ConsentEntity consentEntity) {
        if (consentEntity == null) {
            return null;
        }
        ConsentJpaEntity consentJpaEntity = new ConsentJpaEntity();
        consentJpaEntity.setId(consentEntity.getId());
        consentJpaEntity.setAuthorisationId(consentEntity.getAuthorisationId());
        consentJpaEntity.setRedirectId(consentEntity.getRedirectId());
        consentJpaEntity.setTemporary(consentEntity.isTemporary());
        consentJpaEntity.setBankApi(consentEntity.getBankApi());
        consentJpaEntity.setPsuAccountIban(consentEntity.getPsuAccountIban());
        consentJpaEntity.setBankApiConsentData(consentEntity.getBankApiConsentData());
        return consentJpaEntity;
    }

    protected BookingGroup.Type typeToType(BookingGroupJpaEntity.Type type) {
        BookingGroup.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case STANDING_ORDER: {
                type1 = BookingGroup.Type.STANDING_ORDER;
                break;
            }
            case RECURRENT_INCOME: {
                type1 = BookingGroup.Type.RECURRENT_INCOME;
                break;
            }
            case RECURRENT_SEPA: {
                type1 = BookingGroup.Type.RECURRENT_SEPA;
                break;
            }
            case RECURRENT_NONSEPA: {
                type1 = BookingGroup.Type.RECURRENT_NONSEPA;
                break;
            }
            case CUSTOM: {
                type1 = BookingGroup.Type.CUSTOM;
                break;
            }
            case OTHER_INCOME: {
                type1 = BookingGroup.Type.OTHER_INCOME;
                break;
            }
            case OTHER_EXPENSES: {
                type1 = BookingGroup.Type.OTHER_EXPENSES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)type));
            }
        }
        return type1;
    }

    protected List<BookingPeriod> bookingPeriodJpaEntityListToBookingPeriodList(List<BookingPeriodJpaEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingPeriod> list1 = new ArrayList<BookingPeriod>(list.size());
        for (BookingPeriodJpaEntity bookingPeriodJpaEntity : list) {
            list1.add(this.mapToBookingPeriodEntity(bookingPeriodJpaEntity));
        }
        return list1;
    }

    protected Contract contractJpaEntityToContract(ContractJpaEntity contractJpaEntity) {
        if (contractJpaEntity == null) {
            return null;
        }
        Contract contract = new Contract();
        contract.setLogo(contractJpaEntity.getLogo());
        contract.setHomepage(contractJpaEntity.getHomepage());
        contract.setHotline(contractJpaEntity.getHotline());
        contract.setEmail(contractJpaEntity.getEmail());
        contract.setMandateReference(contractJpaEntity.getMandateReference());
        contract.setInterval(contractJpaEntity.getInterval());
        contract.setCancelled(contractJpaEntity.isCancelled());
        contract.setAmount(contractJpaEntity.getAmount());
        contract.setMainCategory(contractJpaEntity.getMainCategory());
        contract.setSubCategory(contractJpaEntity.getSubCategory());
        contract.setSpecification(contractJpaEntity.getSpecification());
        contract.setProvider(contractJpaEntity.getProvider());
        return contract;
    }

    protected BookingGroup bookingGroupJpaEntityToBookingGroup(BookingGroupJpaEntity bookingGroupJpaEntity) {
        if (bookingGroupJpaEntity == null) {
            return null;
        }
        BookingGroup.BookingGroupBuilder bookingGroup = BookingGroup.builder();
        bookingGroup.type(this.typeToType(bookingGroupJpaEntity.getType()));
        bookingGroup.name(bookingGroupJpaEntity.getName());
        bookingGroup.salaryWage(bookingGroupJpaEntity.isSalaryWage());
        bookingGroup.mainCategory(bookingGroupJpaEntity.getMainCategory());
        bookingGroup.subCategory(bookingGroupJpaEntity.getSubCategory());
        bookingGroup.specification(bookingGroupJpaEntity.getSpecification());
        bookingGroup.otherAccount(bookingGroupJpaEntity.getOtherAccount());
        bookingGroup.amount(bookingGroupJpaEntity.getAmount());
        bookingGroup.bookingPeriods(this.bookingPeriodJpaEntityListToBookingPeriodList(bookingGroupJpaEntity.getBookingPeriods()));
        bookingGroup.contract(this.contractJpaEntityToContract(bookingGroupJpaEntity.getContract()));
        return bookingGroup.build();
    }

    protected List<BookingGroup> bookingGroupJpaEntityListToBookingGroupList(List<BookingGroupJpaEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingGroup> list1 = new ArrayList<BookingGroup>(list.size());
        for (BookingGroupJpaEntity bookingGroupJpaEntity : list) {
            list1.add(this.bookingGroupJpaEntityToBookingGroup(bookingGroupJpaEntity));
        }
        return list1;
    }

    protected ExecutedBooking executedBookingJpaEntityToExecutedBooking(ExecutedBookingJpaEntity executedBookingJpaEntity) {
        if (executedBookingJpaEntity == null) {
            return null;
        }
        ExecutedBooking executedBooking = new ExecutedBooking();
        executedBooking.setBookingId(executedBookingJpaEntity.getBookingId());
        executedBooking.setExecutionDate(executedBookingJpaEntity.getExecutionDate());
        executedBooking.setExecuted(executedBookingJpaEntity.isExecuted());
        return executedBooking;
    }

    protected List<ExecutedBooking> executedBookingJpaEntityListToExecutedBookingList(List<ExecutedBookingJpaEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ExecutedBooking> list1 = new ArrayList<ExecutedBooking>(list.size());
        for (ExecutedBookingJpaEntity executedBookingJpaEntity : list) {
            list1.add(this.executedBookingJpaEntityToExecutedBooking(executedBookingJpaEntity));
        }
        return list1;
    }

    protected List<BookingGroupJpaEntity> bookingGroupListToBookingGroupJpaEntityList(List<BookingGroup> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingGroupJpaEntity> list1 = new ArrayList<BookingGroupJpaEntity>(list.size());
        for (BookingGroup bookingGroup : list) {
            list1.add(this.mapToBookingGroupJpaEntity(bookingGroup));
        }
        return list1;
    }

    protected BookingGroupJpaEntity.Type typeToType1(BookingGroup.Type type) {
        BookingGroupJpaEntity.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case STANDING_ORDER: {
                type1 = BookingGroupJpaEntity.Type.STANDING_ORDER;
                break;
            }
            case RECURRENT_INCOME: {
                type1 = BookingGroupJpaEntity.Type.RECURRENT_INCOME;
                break;
            }
            case RECURRENT_SEPA: {
                type1 = BookingGroupJpaEntity.Type.RECURRENT_SEPA;
                break;
            }
            case RECURRENT_NONSEPA: {
                type1 = BookingGroupJpaEntity.Type.RECURRENT_NONSEPA;
                break;
            }
            case CUSTOM: {
                type1 = BookingGroupJpaEntity.Type.CUSTOM;
                break;
            }
            case OTHER_INCOME: {
                type1 = BookingGroupJpaEntity.Type.OTHER_INCOME;
                break;
            }
            case OTHER_EXPENSES: {
                type1 = BookingGroupJpaEntity.Type.OTHER_EXPENSES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected List<BookingPeriodJpaEntity> bookingPeriodListToBookingPeriodJpaEntityList(List<BookingPeriod> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingPeriodJpaEntity> list1 = new ArrayList<BookingPeriodJpaEntity>(list.size());
        for (BookingPeriod bookingPeriod : list) {
            list1.add(this.mapToBookingPeriodJpaEntity(bookingPeriod));
        }
        return list1;
    }

    protected List<ExecutedBookingJpaEntity> executedBookingListToExecutedBookingJpaEntityList(List<ExecutedBooking> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ExecutedBookingJpaEntity> list1 = new ArrayList<ExecutedBookingJpaEntity>(list.size());
        for (ExecutedBooking executedBooking : list) {
            list1.add(this.mapToExecutedBookingJpaEntity(executedBooking));
        }
        return list1;
    }

    protected AnonymizedBookingJpaEntity anonymizedBookingEntityToAnonymizedBookingJpaEntity(AnonymizedBookingEntity anonymizedBookingEntity) {
        if (anonymizedBookingEntity == null) {
            return null;
        }
        AnonymizedBookingJpaEntity anonymizedBookingJpaEntity = new AnonymizedBookingJpaEntity();
        if (anonymizedBookingEntity.getId() != null) {
            anonymizedBookingJpaEntity.setId(Long.parseLong(anonymizedBookingEntity.getId()));
        }
        anonymizedBookingJpaEntity.setCreditorId(anonymizedBookingEntity.getCreditorId());
        anonymizedBookingJpaEntity.setAmount(anonymizedBookingEntity.getAmount());
        anonymizedBookingJpaEntity.setPurpose(anonymizedBookingEntity.getPurpose());
        return anonymizedBookingJpaEntity;
    }

    protected Map<BankApi, List<TanTransportType>> stringListHashMapToBankApiListMap(HashMap<String, List<TanTransportTypeJpaEntity>> hashMap) {
        if (hashMap == null) {
            return null;
        }
        HashMap<BankApi, List<TanTransportType>> map = new HashMap<BankApi, List<TanTransportType>>(Math.max((int)((float)hashMap.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, List<TanTransportTypeJpaEntity>> entry : hashMap.entrySet()) {
            BankApi key = Enum.valueOf(BankApi.class, entry.getKey());
            List<TanTransportType> value = this.mapToTanTransportTypeList(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    protected HashMap<String, List<TanTransportTypeJpaEntity>> bankApiListMapToStringListHashMap(Map<BankApi, List<TanTransportType>> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, List<TanTransportTypeJpaEntity>> hashMap = new HashMap<String, List<TanTransportTypeJpaEntity>>();
        for (Map.Entry<BankApi, List<TanTransportType>> entry : map.entrySet()) {
            String key = entry.getKey().name();
            List<TanTransportTypeJpaEntity> value = this.mapToTanTransportTypeJpaEntityList(entry.getValue());
            hashMap.put(key, value);
        }
        return hashMap;
    }

    protected TanTransportTypeJpaEntity tanTransportTypeToTanTransportTypeJpaEntity(TanTransportType tanTransportType) {
        if (tanTransportType == null) {
            return null;
        }
        TanTransportTypeJpaEntity tanTransportTypeJpaEntity = new TanTransportTypeJpaEntity();
        tanTransportTypeJpaEntity.setId(tanTransportType.getId());
        tanTransportTypeJpaEntity.setName(tanTransportType.getName());
        tanTransportTypeJpaEntity.setMedium(tanTransportType.getMedium());
        tanTransportTypeJpaEntity.setInputInfo(tanTransportType.getInputInfo());
        tanTransportTypeJpaEntity.setType(tanTransportType.getType());
        return tanTransportTypeJpaEntity;
    }

    protected Balance balanceEntityToBalance(BalanceEntity balanceEntity) {
        if (balanceEntity == null) {
            return null;
        }
        Balance.BalanceBuilder balance = Balance.builder();
        balance.date(balanceEntity.getDate());
        balance.amount(balanceEntity.getAmount());
        balance.currency(balanceEntity.getCurrency());
        return balance.build();
    }

    protected BalancesReport balancesReportEntityToBalancesReport(BalancesReportEntity balancesReportEntity) {
        if (balancesReportEntity == null) {
            return null;
        }
        BalancesReport balancesReport = new BalancesReport();
        balancesReport.setReadyBalance(this.balanceEntityToBalance(balancesReportEntity.getReadyBalance()));
        balancesReport.setUnreadyBalance(this.balanceEntityToBalance(balancesReportEntity.getUnreadyBalance()));
        balancesReport.setCreditBalance(this.balanceEntityToBalance(balancesReportEntity.getCreditBalance()));
        balancesReport.setAvailableBalance(this.balanceEntityToBalance(balancesReportEntity.getAvailableBalance()));
        balancesReport.setUsedBalance(this.balanceEntityToBalance(balancesReportEntity.getUsedBalance()));
        return balancesReport;
    }

    protected BalanceEntity balanceToBalanceEntity(Balance balance) {
        if (balance == null) {
            return null;
        }
        BalanceEntity balanceEntity = new BalanceEntity();
        balanceEntity.setDate(balance.getDate());
        balanceEntity.setAmount(balance.getAmount());
        balanceEntity.setCurrency(balance.getCurrency());
        return balanceEntity;
    }

    protected BalancesReportEntity balancesReportToBalancesReportEntity(BalancesReport balancesReport) {
        if (balancesReport == null) {
            return null;
        }
        BalancesReportEntity balancesReportEntity = new BalancesReportEntity();
        balancesReportEntity.setReadyBalance(this.balanceToBalanceEntity(balancesReport.getReadyBalance()));
        balancesReportEntity.setUnreadyBalance(this.balanceToBalanceEntity(balancesReport.getUnreadyBalance()));
        balancesReportEntity.setCreditBalance(this.balanceToBalanceEntity(balancesReport.getCreditBalance()));
        balancesReportEntity.setAvailableBalance(this.balanceToBalanceEntity(balancesReport.getAvailableBalance()));
        balancesReportEntity.setUsedBalance(this.balanceToBalanceEntity(balancesReport.getUsedBalance()));
        return balancesReportEntity;
    }

    protected BankLoginCredentialInfo bankLoginCredentialInfoJpaEntityToBankLoginCredentialInfo(BankLoginCredentialInfoJpaEntity bankLoginCredentialInfoJpaEntity) {
        if (bankLoginCredentialInfoJpaEntity == null) {
            return null;
        }
        BankLoginCredentialInfo bankLoginCredentialInfo = new BankLoginCredentialInfo();
        bankLoginCredentialInfo.setLabel(bankLoginCredentialInfoJpaEntity.getLabel());
        bankLoginCredentialInfo.setFieldName(bankLoginCredentialInfoJpaEntity.getFieldName());
        bankLoginCredentialInfo.setMasked(bankLoginCredentialInfoJpaEntity.isMasked());
        bankLoginCredentialInfo.setOptional(bankLoginCredentialInfoJpaEntity.isOptional());
        return bankLoginCredentialInfo;
    }

    protected List<BankLoginCredentialInfo> bankLoginCredentialInfoJpaEntityListToBankLoginCredentialInfoList(List<BankLoginCredentialInfoJpaEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BankLoginCredentialInfo> list1 = new ArrayList<BankLoginCredentialInfo>(list.size());
        for (BankLoginCredentialInfoJpaEntity bankLoginCredentialInfoJpaEntity : list) {
            list1.add(this.bankLoginCredentialInfoJpaEntityToBankLoginCredentialInfo(bankLoginCredentialInfoJpaEntity));
        }
        return list1;
    }

    protected BankLoginSettings bankLoginSettingsJpaEntityToBankLoginSettings(BankLoginSettingsJpaEntity bankLoginSettingsJpaEntity) {
        if (bankLoginSettingsJpaEntity == null) {
            return null;
        }
        BankLoginSettings bankLoginSettings = new BankLoginSettings();
        bankLoginSettings.setAuth_type(bankLoginSettingsJpaEntity.getAuthType());
        bankLoginSettings.setIcon(bankLoginSettingsJpaEntity.getIcon());
        bankLoginSettings.setCredentials(this.bankLoginCredentialInfoJpaEntityListToBankLoginCredentialInfoList(bankLoginSettingsJpaEntity.getCredentials()));
        bankLoginSettings.setAdvice(bankLoginSettingsJpaEntity.getAdvice());
        return bankLoginSettings;
    }

    protected BankLoginCredentialInfoJpaEntity bankLoginCredentialInfoToBankLoginCredentialInfoJpaEntity(BankLoginCredentialInfo bankLoginCredentialInfo) {
        if (bankLoginCredentialInfo == null) {
            return null;
        }
        BankLoginCredentialInfoJpaEntity bankLoginCredentialInfoJpaEntity = new BankLoginCredentialInfoJpaEntity();
        bankLoginCredentialInfoJpaEntity.setLabel(bankLoginCredentialInfo.getLabel());
        bankLoginCredentialInfoJpaEntity.setFieldName(bankLoginCredentialInfo.getFieldName());
        bankLoginCredentialInfoJpaEntity.setMasked(bankLoginCredentialInfo.isMasked());
        bankLoginCredentialInfoJpaEntity.setOptional(bankLoginCredentialInfo.isOptional());
        return bankLoginCredentialInfoJpaEntity;
    }

    protected List<BankLoginCredentialInfoJpaEntity> bankLoginCredentialInfoListToBankLoginCredentialInfoJpaEntityList(List<BankLoginCredentialInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BankLoginCredentialInfoJpaEntity> list1 = new ArrayList<BankLoginCredentialInfoJpaEntity>(list.size());
        for (BankLoginCredentialInfo bankLoginCredentialInfo : list) {
            list1.add(this.bankLoginCredentialInfoToBankLoginCredentialInfoJpaEntity(bankLoginCredentialInfo));
        }
        return list1;
    }

    protected BankLoginSettingsJpaEntity bankLoginSettingsToBankLoginSettingsJpaEntity(BankLoginSettings bankLoginSettings) {
        if (bankLoginSettings == null) {
            return null;
        }
        BankLoginSettingsJpaEntity bankLoginSettingsJpaEntity = new BankLoginSettingsJpaEntity();
        bankLoginSettingsJpaEntity.setAuthType(bankLoginSettings.getAuth_type());
        bankLoginSettingsJpaEntity.setIcon(bankLoginSettings.getIcon());
        bankLoginSettingsJpaEntity.setCredentials(this.bankLoginCredentialInfoListToBankLoginCredentialInfoJpaEntityList(bankLoginSettings.getCredentials()));
        bankLoginSettingsJpaEntity.setAdvice(bankLoginSettings.getAdvice());
        return bankLoginSettingsJpaEntity;
    }

    protected BankAccount bankAccountCommonJpaEntityToBankAccount(BankAccountCommonJpaEntity bankAccountCommonJpaEntity) {
        if (bankAccountCommonJpaEntity == null) {
            return null;
        }
        BankAccount bankAccount = new BankAccount();
        bankAccount.setCountry(bankAccountCommonJpaEntity.getCountry());
        bankAccount.setBlz(bankAccountCommonJpaEntity.getBlz());
        bankAccount.setAccountNumber(bankAccountCommonJpaEntity.getAccountNumber());
        bankAccount.setType(bankAccountCommonJpaEntity.getType());
        bankAccount.setCurrency(bankAccountCommonJpaEntity.getCurrency());
        bankAccount.setName(bankAccountCommonJpaEntity.getName());
        bankAccount.setBankName(bankAccountCommonJpaEntity.getBankName());
        bankAccount.setBic(bankAccountCommonJpaEntity.getBic());
        bankAccount.setIban(bankAccountCommonJpaEntity.getIban());
        bankAccount.setOwner(bankAccountCommonJpaEntity.getOwner());
        bankAccount.setSyncStatus(bankAccountCommonJpaEntity.getSyncStatus());
        bankAccount.setLastSync(bankAccountCommonJpaEntity.getLastSync());
        return bankAccount;
    }

    protected BookingCategory bookingCategoryJpaEntityToBookingCategory(BookingCategoryJpaEntity bookingCategoryJpaEntity) {
        if (bookingCategoryJpaEntity == null) {
            return null;
        }
        BookingCategory bookingCategory = new BookingCategory();
        bookingCategory.setLogo(bookingCategoryJpaEntity.getLogo());
        bookingCategory.setHomepage(bookingCategoryJpaEntity.getHomepage());
        bookingCategory.setHotline(bookingCategoryJpaEntity.getHotline());
        bookingCategory.setEmail(bookingCategoryJpaEntity.getEmail());
        bookingCategory.setMandateReference(bookingCategoryJpaEntity.getMandateReference());
        bookingCategory.setInterval(bookingCategoryJpaEntity.getInterval());
        bookingCategory.setCancelled(bookingCategoryJpaEntity.isCancelled());
        bookingCategory.setAmount(bookingCategoryJpaEntity.getAmount());
        bookingCategory.setMainCategory(bookingCategoryJpaEntity.getMainCategory());
        bookingCategory.setSubCategory(bookingCategoryJpaEntity.getSubCategory());
        bookingCategory.setSpecification(bookingCategoryJpaEntity.getSpecification());
        bookingCategory.setProvider(bookingCategoryJpaEntity.getProvider());
        List<String> list = bookingCategoryJpaEntity.getRules();
        if (list != null) {
            bookingCategory.setRules(new HashSet<String>(list));
        }
        bookingCategory.setReceiver(bookingCategoryJpaEntity.getReceiver());
        Map<String, String> map = bookingCategoryJpaEntity.getCustom();
        if (map != null) {
            bookingCategory.setCustom(new HashMap<String, String>(map));
        }
        return bookingCategory;
    }

    protected BankAccountCommonJpaEntity bankAccountToBankAccountCommonJpaEntity(BankAccount bankAccount) {
        if (bankAccount == null) {
            return null;
        }
        BankAccountCommonJpaEntity bankAccountCommonJpaEntity = new BankAccountCommonJpaEntity();
        bankAccountCommonJpaEntity.setOwner(bankAccount.getOwner());
        bankAccountCommonJpaEntity.setCountry(bankAccount.getCountry());
        bankAccountCommonJpaEntity.setBlz(bankAccount.getBlz());
        bankAccountCommonJpaEntity.setBankName(bankAccount.getBankName());
        bankAccountCommonJpaEntity.setAccountNumber(bankAccount.getAccountNumber());
        bankAccountCommonJpaEntity.setType(bankAccount.getType());
        bankAccountCommonJpaEntity.setCurrency(bankAccount.getCurrency());
        bankAccountCommonJpaEntity.setName(bankAccount.getName());
        bankAccountCommonJpaEntity.setBic(bankAccount.getBic());
        bankAccountCommonJpaEntity.setIban(bankAccount.getIban());
        bankAccountCommonJpaEntity.setSyncStatus(bankAccount.getSyncStatus());
        bankAccountCommonJpaEntity.setLastSync(bankAccount.getLastSync());
        return bankAccountCommonJpaEntity;
    }

    protected BookingJpaEntity bookingEntityToBookingJpaEntity(BookingEntity bookingEntity) {
        if (bookingEntity == null) {
            return null;
        }
        BookingJpaEntity bookingJpaEntity = new BookingJpaEntity();
        bookingJpaEntity.setId(bookingEntity.getId());
        bookingJpaEntity.setAccountId(bookingEntity.getAccountId());
        bookingJpaEntity.setUserId(bookingEntity.getUserId());
        bookingJpaEntity.setExternalId(bookingEntity.getExternalId());
        bookingJpaEntity.setOtherAccount(this.bankAccountToBankAccountCommonJpaEntity(bookingEntity.getOtherAccount()));
        bookingJpaEntity.setValutaDate(bookingEntity.getValutaDate());
        bookingJpaEntity.setBookingDate(bookingEntity.getBookingDate());
        bookingJpaEntity.setAmount(bookingEntity.getAmount());
        bookingJpaEntity.setCurrency(bookingEntity.getCurrency());
        bookingJpaEntity.setReversal(bookingEntity.isReversal());
        bookingJpaEntity.setBalance(bookingEntity.getBalance());
        bookingJpaEntity.setCustomerRef(bookingEntity.getCustomerRef());
        bookingJpaEntity.setInstRef(bookingEntity.getInstRef());
        bookingJpaEntity.setOrigValue(bookingEntity.getOrigValue());
        bookingJpaEntity.setChargeValue(bookingEntity.getChargeValue());
        bookingJpaEntity.setText(bookingEntity.getText());
        bookingJpaEntity.setAdditional(bookingEntity.getAdditional());
        bookingJpaEntity.setPrimanota(bookingEntity.getPrimanota());
        bookingJpaEntity.setUsage(bookingEntity.getUsage());
        bookingJpaEntity.setAddkey(bookingEntity.getAddkey());
        bookingJpaEntity.setSepa(bookingEntity.isSepa());
        bookingJpaEntity.setStandingOrder(bookingEntity.isStandingOrder());
        bookingJpaEntity.setCreditorId(bookingEntity.getCreditorId());
        bookingJpaEntity.setMandateReference(bookingEntity.getMandateReference());
        bookingJpaEntity.setBankApi(bookingEntity.getBankApi());
        bookingJpaEntity.setBookingCategory(this.mapToBookingCategoryJpaEntity(bookingEntity.getBookingCategory()));
        bookingJpaEntity.setTransactionCode(bookingEntity.getTransactionCode());
        bookingJpaEntity.setCamt(bookingEntity.isCamt());
        return bookingJpaEntity;
    }

    protected Rule.SIMILARITY_MATCH_TYPE sIMILARITY_MATCH_TYPEToSIMILARITY_MATCH_TYPE(RuleJpaEntity.SIMILARITY_MATCH_TYPE sIMILARITY_MATCH_TYPE) {
        Rule.SIMILARITY_MATCH_TYPE sIMILARITY_MATCH_TYPE1;
        if (sIMILARITY_MATCH_TYPE == null) {
            return null;
        }
        switch (sIMILARITY_MATCH_TYPE) {
            case IBAN: {
                sIMILARITY_MATCH_TYPE1 = Rule.SIMILARITY_MATCH_TYPE.IBAN;
                break;
            }
            case REFERENCE_NAME: {
                sIMILARITY_MATCH_TYPE1 = Rule.SIMILARITY_MATCH_TYPE.REFERENCE_NAME;
                break;
            }
            case PURPOSE: {
                sIMILARITY_MATCH_TYPE1 = Rule.SIMILARITY_MATCH_TYPE.PURPOSE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)sIMILARITY_MATCH_TYPE));
            }
        }
        return sIMILARITY_MATCH_TYPE1;
    }

    protected RuleJpaEntity.SIMILARITY_MATCH_TYPE sIMILARITY_MATCH_TYPEToSIMILARITY_MATCH_TYPE1(Rule.SIMILARITY_MATCH_TYPE sIMILARITY_MATCH_TYPE) {
        RuleJpaEntity.SIMILARITY_MATCH_TYPE sIMILARITY_MATCH_TYPE1;
        if (sIMILARITY_MATCH_TYPE == null) {
            return null;
        }
        switch (sIMILARITY_MATCH_TYPE) {
            case IBAN: {
                sIMILARITY_MATCH_TYPE1 = RuleJpaEntity.SIMILARITY_MATCH_TYPE.IBAN;
                break;
            }
            case REFERENCE_NAME: {
                sIMILARITY_MATCH_TYPE1 = RuleJpaEntity.SIMILARITY_MATCH_TYPE.REFERENCE_NAME;
                break;
            }
            case PURPOSE: {
                sIMILARITY_MATCH_TYPE1 = RuleJpaEntity.SIMILARITY_MATCH_TYPE.PURPOSE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + sIMILARITY_MATCH_TYPE);
            }
        }
        return sIMILARITY_MATCH_TYPE1;
    }

    protected ContractEntity contractJpaEntityToContractEntity(ContractJpaEntity contractJpaEntity) {
        if (contractJpaEntity == null) {
            return null;
        }
        ContractEntity contractEntity = new ContractEntity();
        contractEntity.setLogo(contractJpaEntity.getLogo());
        contractEntity.setHomepage(contractJpaEntity.getHomepage());
        contractEntity.setHotline(contractJpaEntity.getHotline());
        contractEntity.setEmail(contractJpaEntity.getEmail());
        contractEntity.setMandateReference(contractJpaEntity.getMandateReference());
        contractEntity.setInterval(contractJpaEntity.getInterval());
        contractEntity.setCancelled(contractJpaEntity.isCancelled());
        contractEntity.setAmount(contractJpaEntity.getAmount());
        contractEntity.setMainCategory(contractJpaEntity.getMainCategory());
        contractEntity.setSubCategory(contractJpaEntity.getSubCategory());
        contractEntity.setSpecification(contractJpaEntity.getSpecification());
        contractEntity.setProvider(contractJpaEntity.getProvider());
        if (contractJpaEntity.getId() != null) {
            contractEntity.setId(String.valueOf(contractJpaEntity.getId()));
        }
        contractEntity.setUserId(contractJpaEntity.getUserId());
        contractEntity.setAccountId(contractJpaEntity.getAccountId());
        return contractEntity;
    }
}

