/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.jpa.entity.BankAccessJpaEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.BankAccessRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class BankAccessRepositoryImpl
implements BankAccessRepositoryIf {
    private final BankAccessRepositoryJpa bankAccessRepository;
    private final JpaEntityMapper entityMapper;

    public Optional<BankAccessEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccessRepository.findByUserIdAndId(userId, Long.parseLong(id)).map(this.entityMapper::mapToBankAccessEntity);
    }

    public List<BankAccessEntity> findByUserId(String userId) {
        return this.entityMapper.mapToBankAccessEntities(this.bankAccessRepository.findByUserId(userId));
    }

    public void save(BankAccessEntity bankAccess) {
        BankAccessJpaEntity bankAccessMongoEntity = (BankAccessJpaEntity)this.bankAccessRepository.save(this.entityMapper.mapToBankAccessJpaEntity(bankAccess));
        bankAccess.setId(bankAccessMongoEntity.getId().toString());
    }

    public String getBankCode(String id) {
        return this.bankAccessRepository.getBankCode(Long.parseLong(id));
    }

    public boolean exists(String id) {
        return this.bankAccessRepository.existsById(Long.parseLong(id));
    }

    public boolean deleteByUserIdAndBankAccessId(String userId, String id) {
        this.bankAccessRepository.deleteByUserIdAndId(userId, Long.parseLong(id));
        return true;
    }

    public BankAccessRepositoryImpl(BankAccessRepositoryJpa bankAccessRepository, JpaEntityMapper entityMapper) {
        this.bankAccessRepository = bankAccessRepository;
        this.entityMapper = entityMapper;
    }
}

