/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.BookingsIndexEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.BookingsIndexRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.BookingsIndexRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class BookingsIndexRepositoryImpl
implements BookingsIndexRepositoryIf {
    private final BookingsIndexRepositoryJpa repository;
    private final JpaEntityMapper entityMapper;

    public void save(BookingsIndexEntity entity) {
        this.repository.deleteByUserIdAndAccountId(entity.getUserId(), entity.getAccountId());
        this.repository.save(this.entityMapper.mapToBookingsIndexJpaEntity(entity));
    }

    public void delete(BookingsIndexEntity entity) {
        this.repository.deleteById(entity.getId());
    }

    public List<BookingsIndexEntity> search(String terms) {
        return null;
    }

    public Optional<BookingsIndexEntity> findByUserIdAndAccountId(String userId, String accountId) {
        return this.repository.findByUserIdAndAccountId(userId, accountId).map(this.entityMapper::mapToBookingsIndexEntity);
    }

    public BookingsIndexRepositoryImpl(BookingsIndexRepositoryJpa repository, JpaEntityMapper entityMapper) {
        this.repository = repository;
        this.entityMapper = entityMapper;
    }
}

