/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.jpa.entity.UserJpaEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.UserRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class UserRepositoryImpl
implements UserRepositoryIf {
    private final UserRepositoryJpa userRepository;
    private final JpaEntityMapper entityMapper;

    public Optional<UserEntity> findById(String id) {
        return this.userRepository.findById(id).map(this.entityMapper::mapToUserEntity);
    }

    public List<String> findExpiredUser() {
        return this.userRepository.findByExpireUserLessThan(LocalDateTime.now()).stream().map(UserJpaEntity::getId).map(Object::toString).collect(Collectors.toList());
    }

    public Optional<LocalDateTime> getRulesLastChangeDate(String id) {
        return Optional.ofNullable(this.userRepository.getRulesLastChangeDate(id));
    }

    public void setRulesLastChangeDate(String userId, LocalDateTime dateTime) {
        this.userRepository.setRulesLastChangeDate(dateTime, userId);
    }

    public boolean exists(String userId) {
        return this.userRepository.existsById(userId);
    }

    public void save(UserEntity userEntity) {
        this.userRepository.save(this.entityMapper.mapToUserJpaEntity(userEntity));
    }

    public void delete(String userId) {
        this.userRepository.deleteById(userId);
    }

    public UserRepositoryImpl(UserRepositoryJpa userRepository, JpaEntityMapper entityMapper) {
        this.userRepository = userRepository;
        this.entityMapper = entityMapper;
    }
}

