/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.BookingRuleRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.BookingRuleRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class BookingRuleRepositoryImpl
implements BookingRuleRepositoryIf {
    private final BookingRuleRepositoryJpa ruleRepository;
    private final JpaEntityMapper entityMapper;

    public List<RuleEntity> findByUserId(String userId) {
        return this.entityMapper.mapToRuleEntities(this.ruleRepository.findByUserId(userId));
    }

    public Page<RuleEntity> findAllPageable(Pageable pageable) {
        Page pageRules = this.ruleRepository.findAll(pageable);
        return pageRules.map(this.entityMapper::mapToRuleEntity);
    }

    public List<RuleEntity> findAll() {
        return this.entityMapper.mapToRuleEntities(this.ruleRepository.findAll());
    }

    public void createOrUpdateRule(RuleEntity ruleEntity) {
        ruleEntity.updateSearchIndex();
        this.ruleRepository.save(this.entityMapper.mapToRuleJpaEntity(ruleEntity));
    }

    public List<RuleEntity> search(String text) {
        return null;
    }

    public Optional<RuleEntity> findById(String id) {
        return this.ruleRepository.findById(id).map(this.entityMapper::mapToRuleEntity);
    }

    public Optional<RuleEntity> findByRuleId(String ruleId) {
        return this.ruleRepository.findByRuleId(ruleId).map(this.entityMapper::mapToRuleEntity);
    }

    public void deleteRule(String id) {
        this.ruleRepository.deleteById(id);
    }

    public BookingRuleRepositoryImpl(BookingRuleRepositoryJpa ruleRepository, JpaEntityMapper entityMapper) {
        this.ruleRepository = ruleRepository;
        this.entityMapper = entityMapper;
    }
}

