/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.StandingOrderRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class StandingOrderRepositoryImpl
implements StandingOrderRepositoryIf {
    private final StandingOrderRepositoryJpa standingOrderRepository;
    private final JpaEntityMapper entityMapper;

    public List<StandingOrderEntity> findByUserIdAndAccountId(String userId, String accountId) {
        return this.entityMapper.mapToStandingOrderEntities(this.standingOrderRepository.findByUserIdAndAccountId(userId, accountId));
    }

    public void save(List<StandingOrderEntity> standingOrders) {
        this.standingOrderRepository.saveAll(this.entityMapper.mapToStandingOrderJpaEntities(standingOrders));
    }

    public void save(StandingOrderEntity standingOrder) {
        this.standingOrderRepository.save(this.entityMapper.mapToStandingOrderJpaEntity(standingOrder));
    }

    public void deleteByAccountId(String accountId) {
        this.standingOrderRepository.deleteByAccountId(accountId);
    }

    public StandingOrderRepositoryImpl(StandingOrderRepositoryJpa standingOrderRepository, JpaEntityMapper entityMapper) {
        this.standingOrderRepository = standingOrderRepository;
        this.entityMapper = entityMapper;
    }
}

