/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.jpa.entity.BookingJpaEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.BookingPageableRepositoryJpa;
import de.adorsys.multibanking.jpa.repository.BookingRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class BookingRepositoryImpl
implements BookingRepositoryIf {
    private final BookingRepositoryJpa bookingRepository;
    private final BookingPageableRepositoryJpa bookingPageableRepositoryMongodb;
    private final JpaEntityMapper entityMapper;

    public Page<BookingEntity> findPageableByUserIdAndAccountIdAndBankApi(Pageable pageable, String userId, String bankAccountId, BankApi bankApi) {
        Page<BookingJpaEntity> bookingsPage = this.bookingPageableRepositoryMongodb.findByUserIdAndAccountIdAndBankApi(pageable, userId, bankAccountId, bankApi);
        return bookingsPage.map(this.entityMapper::mapToBookingEntity);
    }

    public List<BookingEntity> findByUserIdAndAccountIdAndBankApi(String userId, String bankAccountId, BankApi bankApi) {
        return this.entityMapper.mapToBookingEntities(this.bookingRepository.findByUserIdAndAccountIdAndBankApi(userId, bankAccountId, bankApi, new Sort(Sort.Direction.DESC, new String[]{"valutaDate"})));
    }

    public Optional<BookingEntity> findByUserIdAndId(String userId, String bookingId) {
        return this.bookingRepository.findByUserIdAndId(userId, bookingId).map(this.entityMapper::mapToBookingEntity);
    }

    public List<BookingEntity> findByUserIdAndIds(String name, List<String> ids) {
        return this.entityMapper.mapToBookingEntities(this.bookingRepository.findByUserIdAndIdIn(name, ids));
    }

    public void save(List<BookingEntity> bookingEntities) {
        bookingEntities.stream().filter(bookingEntity -> bookingEntity.getId() == null).forEach(bookingEntity -> bookingEntity.setId(UUID.randomUUID().toString()));
        this.bookingRepository.saveAll(this.entityMapper.mapToBookingJpaEntities(bookingEntities));
    }

    public void deleteByAccountId(String id) {
        this.bookingRepository.deleteByAccountId(id);
    }

    public void deleteByUserIdAndAccountId(String userId, String accountId) {
        this.bookingRepository.deleteByUserIdAndAccountId(userId, accountId);
    }

    public BookingRepositoryImpl(BookingRepositoryJpa bookingRepository, BookingPageableRepositoryJpa bookingPageableRepositoryMongodb, JpaEntityMapper entityMapper) {
        this.bookingRepository = bookingRepository;
        this.bookingPageableRepositoryMongodb = bookingPageableRepositoryMongodb;
        this.entityMapper = entityMapper;
    }
}

