/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.jpa.impl;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.jpa.entity.BankAccountJpaEntity;
import de.adorsys.multibanking.jpa.mapper.JpaEntityMapper;
import de.adorsys.multibanking.jpa.repository.BankAccountRepositoryJpa;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"jpa"})
@Service
public class BankAccountRepositoryImpl
implements BankAccountRepositoryIf {
    private final BankAccountRepositoryJpa bankAccountRepository;
    private final JpaEntityMapper entityMapper;

    public List<BankAccountEntity> findByUserId(String userId) {
        return this.entityMapper.mapToBankAccountEntities(this.bankAccountRepository.findByUserId(userId));
    }

    public List<BankAccountEntity> findByUserIdAndBankAccessId(String userId, String bankAccessId) {
        return this.entityMapper.mapToBankAccountEntities(this.bankAccountRepository.findByUserIdAndBankAccessId(userId, bankAccessId));
    }

    public Optional<BankAccountEntity> findByUserIdAndId(String userId, String id) {
        return this.bankAccountRepository.findByUserIdAndId(userId, new Long(id)).map(this.entityMapper::mapToBankAccountEntity);
    }

    public boolean exists(String accountId) {
        return this.bankAccountRepository.existsById(new Long(accountId));
    }

    public void save(List<BankAccountEntity> bankAccounts) {
        this.bankAccountRepository.saveAll(this.entityMapper.mapToBankAccountJpaEntities(bankAccounts));
    }

    public void save(BankAccountEntity bankAccount) {
        bankAccount.setId(((BankAccountJpaEntity)this.bankAccountRepository.save(this.entityMapper.mapToBankAccountJpaEntity(bankAccount))).getId().toString());
    }

    public BankAccount.SyncStatus getSyncStatus(String accountId) {
        return this.bankAccountRepository.getSyncStatus(NumberUtils.toLong((String)accountId));
    }

    public void updateSyncStatus(String accountId, BankAccount.SyncStatus syncStatus) {
        this.bankAccountRepository.updateSyncStatus(syncStatus, NumberUtils.toLong((String)accountId));
    }

    public List<BankAccountEntity> deleteByBankAccess(String accessId) {
        return this.entityMapper.mapToBankAccountEntities(this.bankAccountRepository.deleteByBankAccessId(accessId));
    }

    public Optional<BankAccountEntity> findOne(String accountId) {
        return this.bankAccountRepository.findById(new Long(accountId)).map(this.entityMapper::mapToBankAccountEntity);
    }

    public BankAccountRepositoryImpl(BankAccountRepositoryJpa bankAccountRepository, JpaEntityMapper entityMapper) {
        this.bankAccountRepository = bankAccountRepository;
        this.entityMapper = entityMapper;
    }
}

