/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.encrypt.Encrypted;
import domain.Booking;
import java.util.Date;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@CompoundIndexes(value={@CompoundIndex(name="booking_index", def="{'userId': 1, 'accountId': 1}"), @CompoundIndex(name="booking_unique_index", def="{'externalId': 1, 'accountId': 1}", unique=true)})
@Encrypted(exclude={"_id", "accountId", "externalId", "userId", "valutaDate", "bookingDate", "bankApi", "expireBooking"})
public class BookingEntity
extends Booking {
    @Id
    private String id;
    private String accountId;
    private String userId;
    @Indexed(name="expireBooking", expireAfterSeconds=0)
    private Date expireBooking;

    public BookingEntity id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getExpireBooking() {
        return this.expireBooking;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExpireBooking(Date expireBooking) {
        this.expireBooking = expireBooking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookingEntity)) {
            return false;
        }
        BookingEntity other = (BookingEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Date this$expireBooking = this.getExpireBooking();
        Date other$expireBooking = other.getExpireBooking();
        return !(this$expireBooking == null ? other$expireBooking != null : !((Object)this$expireBooking).equals(other$expireBooking));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BookingEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Date $expireBooking = this.getExpireBooking();
        result = result * 59 + ($expireBooking == null ? 43 : ((Object)$expireBooking).hashCode());
        return result;
    }

    public String toString() {
        return "BookingEntity(id=" + this.getId() + ", accountId=" + this.getAccountId() + ", userId=" + this.getUserId() + ", expireBooking=" + this.getExpireBooking() + ")";
    }
}

