/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.encrypt.Encrypted;
import domain.BankAccount;
import java.util.Date;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@Encrypted(exclude={"_id", "bankAccessId", "userId", "syncStatus", "expireBankAccount"})
@CompoundIndexes(value={@CompoundIndex(name="account_index", def="{'userId': 1, 'bankAccessId': 1}")})
public class BankAccountEntity
extends BankAccount {
    @Id
    private String id;
    private String bankAccessId;
    private String userId;
    @Indexed(name="expireBankAccount", expireAfterSeconds=0)
    private Date expireBankAccount;

    public String getId() {
        return this.id;
    }

    public BankAccountEntity id(String id) {
        this.id = id;
        return this;
    }

    public BankAccountEntity bankAccessId(String bankAccessId) {
        this.bankAccessId = bankAccessId;
        return this;
    }

    public String getBankAccessId() {
        return this.bankAccessId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getExpireBankAccount() {
        return this.expireBankAccount;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBankAccessId(String bankAccessId) {
        this.bankAccessId = bankAccessId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExpireBankAccount(Date expireBankAccount) {
        this.expireBankAccount = expireBankAccount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccountEntity)) {
            return false;
        }
        BankAccountEntity other = (BankAccountEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$bankAccessId = this.getBankAccessId();
        String other$bankAccessId = other.getBankAccessId();
        if (this$bankAccessId == null ? other$bankAccessId != null : !this$bankAccessId.equals(other$bankAccessId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Date this$expireBankAccount = this.getExpireBankAccount();
        Date other$expireBankAccount = other.getExpireBankAccount();
        return !(this$expireBankAccount == null ? other$expireBankAccount != null : !((Object)this$expireBankAccount).equals(other$expireBankAccount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccountEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $bankAccessId = this.getBankAccessId();
        result = result * 59 + ($bankAccessId == null ? 43 : $bankAccessId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Date $expireBankAccount = this.getExpireBankAccount();
        result = result * 59 + ($expireBankAccount == null ? 43 : ((Object)$expireBankAccount).hashCode());
        return result;
    }

    public String toString() {
        return "BankAccountEntity(id=" + this.getId() + ", bankAccessId=" + this.getBankAccessId() + ", userId=" + this.getUserId() + ", expireBankAccount=" + this.getExpireBankAccount() + ")";
    }
}

