/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.encrypt.Encrypted;
import domain.Booking;
import domain.BookingCategory;
import domain.Contract;
import java.util.Optional;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@CompoundIndexes(value={@CompoundIndex(name="booking_index", def="{'userId': 1, 'accountId': 1}"), @CompoundIndex(name="booking_unique_index", def="{'externalId': 1, 'accountId': 1}", unique=true)})
@Encrypted(exclude={"_id", "accountId", "externalId", "userId", "valutaDate", "bookingDate", "bankApi"})
public class BookingEntity
extends Booking {
    @Id
    private String id;
    private String accountId;
    private String userId;

    public BookingEntity id(String id) {
        this.id = id;
        return this;
    }

    public boolean isContract() {
        return Optional.of(this).map(Booking::getBookingCategory).map(BookingCategory::getContract).map(Contract::getInterval).isPresent();
    }

    public String getId() {
        return this.id;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookingEntity)) {
            return false;
        }
        BookingEntity other = (BookingEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BookingEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }

    public String toString() {
        return "BookingEntity(id=" + this.getId() + ", accountId=" + this.getAccountId() + ", userId=" + this.getUserId() + ")";
    }
}

