/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.encrypt.Encrypted;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@Encrypted(exclude={"_id", "accountId", "userId", "analyticsDate"})
@CompoundIndexes(value={@CompoundIndex(name="account_index", def="{'userId': 1, 'accountId': 1}")})
public class AccountAnalyticsEntity {
    @Id
    private String id;
    private String accountId;
    private String userId;
    private LocalDate analyticsDate = LocalDate.now();
    private BigDecimal incomeTotal = new BigDecimal(0);
    private BigDecimal incomeFixed = new BigDecimal(0);
    private BigDecimal incomeNext = new BigDecimal(0);
    private BigDecimal expensesTotal = new BigDecimal(0);
    private BigDecimal expensesFixed = new BigDecimal(0);
    private BigDecimal expensesNext = new BigDecimal(0);
    private BigDecimal balanceCalculated = new BigDecimal(0);

    public String getId() {
        return this.id;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public LocalDate getAnalyticsDate() {
        return this.analyticsDate;
    }

    public BigDecimal getIncomeTotal() {
        return this.incomeTotal;
    }

    public BigDecimal getIncomeFixed() {
        return this.incomeFixed;
    }

    public BigDecimal getIncomeNext() {
        return this.incomeNext;
    }

    public BigDecimal getExpensesTotal() {
        return this.expensesTotal;
    }

    public BigDecimal getExpensesFixed() {
        return this.expensesFixed;
    }

    public BigDecimal getExpensesNext() {
        return this.expensesNext;
    }

    public BigDecimal getBalanceCalculated() {
        return this.balanceCalculated;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAnalyticsDate(LocalDate analyticsDate) {
        this.analyticsDate = analyticsDate;
    }

    public void setIncomeTotal(BigDecimal incomeTotal) {
        this.incomeTotal = incomeTotal;
    }

    public void setIncomeFixed(BigDecimal incomeFixed) {
        this.incomeFixed = incomeFixed;
    }

    public void setIncomeNext(BigDecimal incomeNext) {
        this.incomeNext = incomeNext;
    }

    public void setExpensesTotal(BigDecimal expensesTotal) {
        this.expensesTotal = expensesTotal;
    }

    public void setExpensesFixed(BigDecimal expensesFixed) {
        this.expensesFixed = expensesFixed;
    }

    public void setExpensesNext(BigDecimal expensesNext) {
        this.expensesNext = expensesNext;
    }

    public void setBalanceCalculated(BigDecimal balanceCalculated) {
        this.balanceCalculated = balanceCalculated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAnalyticsEntity)) {
            return false;
        }
        AccountAnalyticsEntity other = (AccountAnalyticsEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        LocalDate this$analyticsDate = this.getAnalyticsDate();
        LocalDate other$analyticsDate = other.getAnalyticsDate();
        if (this$analyticsDate == null ? other$analyticsDate != null : !((Object)this$analyticsDate).equals(other$analyticsDate)) {
            return false;
        }
        BigDecimal this$incomeTotal = this.getIncomeTotal();
        BigDecimal other$incomeTotal = other.getIncomeTotal();
        if (this$incomeTotal == null ? other$incomeTotal != null : !((Object)this$incomeTotal).equals(other$incomeTotal)) {
            return false;
        }
        BigDecimal this$incomeFixed = this.getIncomeFixed();
        BigDecimal other$incomeFixed = other.getIncomeFixed();
        if (this$incomeFixed == null ? other$incomeFixed != null : !((Object)this$incomeFixed).equals(other$incomeFixed)) {
            return false;
        }
        BigDecimal this$incomeNext = this.getIncomeNext();
        BigDecimal other$incomeNext = other.getIncomeNext();
        if (this$incomeNext == null ? other$incomeNext != null : !((Object)this$incomeNext).equals(other$incomeNext)) {
            return false;
        }
        BigDecimal this$expensesTotal = this.getExpensesTotal();
        BigDecimal other$expensesTotal = other.getExpensesTotal();
        if (this$expensesTotal == null ? other$expensesTotal != null : !((Object)this$expensesTotal).equals(other$expensesTotal)) {
            return false;
        }
        BigDecimal this$expensesFixed = this.getExpensesFixed();
        BigDecimal other$expensesFixed = other.getExpensesFixed();
        if (this$expensesFixed == null ? other$expensesFixed != null : !((Object)this$expensesFixed).equals(other$expensesFixed)) {
            return false;
        }
        BigDecimal this$expensesNext = this.getExpensesNext();
        BigDecimal other$expensesNext = other.getExpensesNext();
        if (this$expensesNext == null ? other$expensesNext != null : !((Object)this$expensesNext).equals(other$expensesNext)) {
            return false;
        }
        BigDecimal this$balanceCalculated = this.getBalanceCalculated();
        BigDecimal other$balanceCalculated = other.getBalanceCalculated();
        return !(this$balanceCalculated == null ? other$balanceCalculated != null : !((Object)this$balanceCalculated).equals(other$balanceCalculated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountAnalyticsEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        LocalDate $analyticsDate = this.getAnalyticsDate();
        result = result * 59 + ($analyticsDate == null ? 43 : ((Object)$analyticsDate).hashCode());
        BigDecimal $incomeTotal = this.getIncomeTotal();
        result = result * 59 + ($incomeTotal == null ? 43 : ((Object)$incomeTotal).hashCode());
        BigDecimal $incomeFixed = this.getIncomeFixed();
        result = result * 59 + ($incomeFixed == null ? 43 : ((Object)$incomeFixed).hashCode());
        BigDecimal $incomeNext = this.getIncomeNext();
        result = result * 59 + ($incomeNext == null ? 43 : ((Object)$incomeNext).hashCode());
        BigDecimal $expensesTotal = this.getExpensesTotal();
        result = result * 59 + ($expensesTotal == null ? 43 : ((Object)$expensesTotal).hashCode());
        BigDecimal $expensesFixed = this.getExpensesFixed();
        result = result * 59 + ($expensesFixed == null ? 43 : ((Object)$expensesFixed).hashCode());
        BigDecimal $expensesNext = this.getExpensesNext();
        result = result * 59 + ($expensesNext == null ? 43 : ((Object)$expensesNext).hashCode());
        BigDecimal $balanceCalculated = this.getBalanceCalculated();
        result = result * 59 + ($balanceCalculated == null ? 43 : ((Object)$balanceCalculated).hashCode());
        return result;
    }

    public String toString() {
        return "AccountAnalyticsEntity(id=" + this.getId() + ", accountId=" + this.getAccountId() + ", userId=" + this.getUserId() + ", analyticsDate=" + this.getAnalyticsDate() + ", incomeTotal=" + this.getIncomeTotal() + ", incomeFixed=" + this.getIncomeFixed() + ", incomeNext=" + this.getIncomeNext() + ", expensesTotal=" + this.getExpensesTotal() + ", expensesFixed=" + this.getExpensesFixed() + ", expensesNext=" + this.getExpensesNext() + ", balanceCalculated=" + this.getBalanceCalculated() + ")";
    }
}

