/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.pers.jcloud.repository;

import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.pers.jcloud.domain.UserMainRecord;
import de.adorsys.multibanking.pers.jcloud.repository.ListItemHandler;
import de.adorsys.multibanking.pers.jcloud.repository.ListUtils;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.utils.ObjectPersistenceAdapter;
import de.adorsys.multibanking.pers.utils.UserDataNamingPolicy;
import domain.BankAccount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankAccountRepositoryImpl
implements BankAccountRepositoryIf {
    @Autowired
    private KeyCredentials keyCredentials;
    @Autowired
    private UserDataNamingPolicy namingPolicy;
    @Autowired
    private ObjectPersistenceAdapter objectPersistenceAdapter;
    static ListItemHandler<BankAccountEntity> handler = new ListItemHandler<BankAccountEntity>(){

        @Override
        public boolean idEquals(BankAccountEntity a, BankAccountEntity b) {
            return StringUtils.equals((CharSequence)a.getId(), (CharSequence)b.getId());
        }

        @Override
        public boolean newId(BankAccountEntity a) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getId()})) {
                return false;
            }
            a.setId(UUID.randomUUID().toString());
            return true;
        }
    };

    public List<BankAccountEntity> findByUserIdAndBankAccessId(String userId, String bankAccessId) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        if (userMainRecord == null) {
            return Collections.emptyList();
        }
        return userMainRecord.getBankAccountMap().get(bankAccessId);
    }

    public Optional<BankAccountEntity> findByUserIdAndId(String userId, String id) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        BankAccountEntity accountEntity = ListUtils.find(userMainRecord, id);
        if (accountEntity == null) {
            return Optional.empty();
        }
        return Optional.of(accountEntity);
    }

    public boolean exists(String accountId) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        return ListUtils.find(userMainRecord, accountId) != null;
    }

    public void save(List<BankAccountEntity> bankAccounts) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        if (userMainRecord == null) {
            userMainRecord = new UserMainRecord();
        }
        Map<String, List<BankAccountEntity>> bankAccountMap = userMainRecord.getBankAccountMap();
        for (BankAccountEntity bankAccountEntity : bankAccounts) {
            this.add(bankAccountMap, bankAccountEntity);
        }
        this.objectPersistenceAdapter.store(userMainRecordhandle, userMainRecord, this.keyCredentials);
    }

    public void save(BankAccountEntity bankAccount) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        if (userMainRecord == null) {
            userMainRecord = new UserMainRecord();
        }
        Map<String, List<BankAccountEntity>> bankAccountMap = userMainRecord.getBankAccountMap();
        this.add(bankAccountMap, bankAccount);
        this.objectPersistenceAdapter.store(userMainRecordhandle, userMainRecord, this.keyCredentials);
    }

    public BankAccount.SyncStatus getSyncStatus(String accountId) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        BankAccountEntity accountEntity = ListUtils.find(userMainRecord, accountId);
        if (accountEntity == null) {
            return BankAccount.SyncStatus.READY;
        }
        return accountEntity.getSyncStatus();
    }

    public void updateSyncStatus(String accountId, BankAccount.SyncStatus syncStatus) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        BankAccountEntity accountEntity = ListUtils.find(userMainRecord, accountId);
        if (accountEntity == null) {
            throw new RuntimeException((Throwable)new ObjectNotFoundException("Account with id: " + accountId + " not found"));
        }
        accountEntity.setSyncStatus(syncStatus);
        this.add(userMainRecord.getBankAccountMap(), accountEntity);
        this.objectPersistenceAdapter.store(userMainRecordhandle, userMainRecord, this.keyCredentials);
    }

    public List<BankAccountEntity> deleteByBankAccess(String accessId) {
        return null;
    }

    private void add(Map<String, List<BankAccountEntity>> bankAccountMap, BankAccountEntity bankAccount) {
        String bankAccessId = bankAccount.getBankAccessId();
        List<BankAccountEntity> list = bankAccountMap.get(bankAccessId);
        if (list == null) {
            list = new ArrayList<BankAccountEntity>();
            bankAccountMap.put(bankAccessId, list);
        }
        ListUtils.add(bankAccount, list, handler);
    }
}

