/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.pers.jcloud.repository;

import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.pers.jcloud.domain.UserBookingRecord;
import de.adorsys.multibanking.pers.jcloud.repository.ListItemHandler;
import de.adorsys.multibanking.pers.jcloud.repository.ListUtils;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.pers.utils.ObjectPersistenceAdapter;
import de.adorsys.multibanking.pers.utils.UserDataNamingPolicy;
import domain.BankApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BookingRepositoryImpl
implements BookingRepositoryIf {
    @Autowired
    private KeyCredentials keyCredentials;
    @Autowired
    private UserDataNamingPolicy namingPolicy;
    @Autowired
    private ObjectPersistenceAdapter objectPersistenceAdapter;
    static ListItemHandler<BookingEntity> handler = new ListItemHandler<BookingEntity>(){

        @Override
        public boolean idEquals(BookingEntity a, BookingEntity b) {
            return StringUtils.equals((CharSequence)a.getId(), (CharSequence)b.getId());
        }

        @Override
        public boolean newId(BookingEntity a) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getId()})) {
                return false;
            }
            a.setId(UUID.randomUUID().toString());
            return true;
        }
    };

    public List<BookingEntity> findByUserIdAndAccountIdAndBankApi(String userId, String bankAccountId, BankApi bankApi) {
        ObjectHandle bookingsHandle = this.namingPolicy.handleForBookings(this.keyCredentials, bankAccountId, bankApi);
        UserBookingRecord userBookingRecord = this.objectPersistenceAdapter.load(bookingsHandle, UserBookingRecord.class, this.keyCredentials);
        if (userBookingRecord == null) {
            return Collections.emptyList();
        }
        return userBookingRecord.getBookings();
    }

    public Optional<BookingEntity> findByUserIdAndId(String userId, String bookingId) {
        throw new UnsupportedOperationException();
    }

    public void insert(List<BookingEntity> bookingEntities) {
        HashMap<String, UserBookingRecord> bookingRecords = new HashMap<String, UserBookingRecord>();
        HashMap<String, ObjectHandle> bookingHandles = new HashMap<String, ObjectHandle>();
        for (BookingEntity bookingEntity : bookingEntities) {
            BankApi bankApi;
            String accountId = bookingEntity.getAccountId();
            ObjectHandle bookingsHandle = this.namingPolicy.handleForBookings(this.keyCredentials, accountId, bankApi = bookingEntity.getBankApi());
            UserBookingRecord userBookingRecord = (UserBookingRecord)bookingRecords.get(bookingsHandle.getName());
            if (userBookingRecord == null) {
                userBookingRecord = this.objectPersistenceAdapter.load(bookingsHandle, UserBookingRecord.class, this.keyCredentials);
                if (userBookingRecord == null) {
                    userBookingRecord = new UserBookingRecord();
                }
                bookingRecords.put(bookingsHandle.getName(), userBookingRecord);
                bookingHandles.put(bookingsHandle.getName(), bookingsHandle);
            }
            this.addBooking(userBookingRecord, bookingEntity);
        }
        Set entrySet = bookingRecords.entrySet();
        for (Map.Entry entry : entrySet) {
            this.objectPersistenceAdapter.store((ObjectHandle)bookingHandles.get(entry.getKey()), (UserBookingRecord)entry.getValue(), this.keyCredentials);
        }
    }

    public List<BookingEntity> save(List<BookingEntity> bookingEntities) {
        return bookingEntities;
    }

    public void deleteByAccountId(String id) {
    }

    private void addBooking(UserBookingRecord userBookingRecord, BookingEntity booking) {
        ListUtils.add(booking, userBookingRecord.getBookings(), handler);
    }
}

