/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.inmemory;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.mock.domain.BankAccessData;
import de.adorsys.multibanking.mock.domain.BankAccountData;
import de.adorsys.multibanking.mock.domain.MockAccount;
import de.adorsys.multibanking.mock.domain.XLSBank;
import de.adorsys.multibanking.mock.loader.BankAccesLoader;
import de.adorsys.multibanking.mock.loader.BankAccountLoader;
import de.adorsys.multibanking.mock.loader.BookingLoader;
import de.adorsys.multibanking.mock.loader.DataSheetLoader;
import de.adorsys.multibanking.mock.loader.MockBankCatalogue;
import de.adorsys.multibanking.mock.loader.StandingOrderLoader;
import de.adorsys.multibanking.mock.service.XLSBankAccessService;
import de.adorsys.multibanking.mock.service.XLSBankAccountService;
import de.adorsys.multibanking.mock.service.XLSBookingService;
import de.adorsys.multibanking.mock.service.XLSStandingOrderService;
import de.adorsys.onlinebanking.mock.MockBanking;
import domain.LoadAccountInformationRequest;
import domain.LoadAccountInformationResponse;
import domain.LoadBookingsRequest;
import domain.LoadBookingsResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SimpleMockBanking
extends MockBanking {
    private ObjectMapper mapper = new ObjectMapper();
    private MockAccount data = new MockAccount();

    public SimpleMockBanking(InputStream banksStream, InputStream bookingsStream) {
        try {
            this.load(banksStream, bookingsStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public LoadAccountInformationResponse loadBankAccounts(Optional<String> bankingUrl, LoadAccountInformationRequest loadAccountInformationRequest) {
        List bankAccounts = this.data.loadBankAccounts(loadAccountInformationRequest.getBankAccess(), loadAccountInformationRequest.getBankCode(), loadAccountInformationRequest.getPin());
        return LoadAccountInformationResponse.builder().bankAccounts(bankAccounts).build();
    }

    public LoadBookingsResponse loadBookings(Optional<String> bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        String bankLogin = loadBookingsRequest.getBankAccess().getBankLogin();
        String iban = loadBookingsRequest.getBankAccount().getIban();
        BankAccessData bankAccessData = this.data.accessOrException(bankLogin);
        bankAccessData.checkPin(loadBookingsRequest.getPin());
        BankAccountData accountData = this.data.accessOrException(bankLogin).accountDataOrException(iban);
        List bookings = accountData.bookings();
        ArrayList standingOrders = new ArrayList(accountData.standingOrders().values());
        return LoadBookingsResponse.builder().bookings(bookings).standingOrders(standingOrders).build();
    }

    private void load(InputStream banksStream, InputStream bookingsStream) throws IOException {
        if (banksStream == null) {
            banksStream = SimpleMockBanking.class.getResourceAsStream("/mock_bank.json");
        }
        List banks = (List)this.mapper.readValue(banksStream, (TypeReference)new TypeReference<List<XLSBank>>(){});
        BankAccesLoader bankAccesLoader = new BankAccesLoader((XLSBankAccessService)this.data);
        MockBankCatalogue bankCatalogue = new MockBankCatalogue();
        bankCatalogue.setBanks(banks);
        BankAccountLoader bankAccountLoader = new BankAccountLoader((XLSBankAccountService)this.data, bankCatalogue);
        BookingLoader bookingLoader = new BookingLoader((XLSBookingService)this.data);
        StandingOrderLoader standingOrderLoader = new StandingOrderLoader((XLSStandingOrderService)this.data);
        DataSheetLoader dataSheetLoader = new DataSheetLoader(bankAccesLoader, bankAccountLoader, bookingLoader, standingOrderLoader);
        if (bookingsStream == null) {
            bookingsStream = SimpleMockBanking.class.getResourceAsStream("/mock_bank.xls");
        }
        dataSheetLoader.loadDataSheet(bookingsStream);
    }
}

